/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.weather;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.events.Listener;
import net.risingworld.api.objects.Time;

public class Weather
extends Plugin
implements Listener {
    static final double CHANGES_PER_DAY_DEF = 3.7;
    static final double MASTER_DEF = 1.0;
    static final double TIME_SCALE_DEF = 1.75;
    static final String localeLanguageDef = "en";
    static final String VERSION = "0.1.1";
    static final int DAYS_PER_PERIOD = 15;
    static final double MASTER_MIN = 0.0;
    static final double MASTER_MAX = 1.0;
    static final float CYCLE_MIN = 70.0f;
    static final int NUM_OF_PERIODS = 24;
    static final int NUM_OF_WEATHERS = 10;
    static final int[] monthToYd;
    static final double[][] weatherProb;
    static double changesPerDay;
    static Locale locale;
    static double master;
    static Server server;
    static double timeScale;
    static Timer timer;
    static net.risingworld.api.objects.Weather[] weathers;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        monthToYd = nArray;
        weatherProb = new double[][]{{4.0, 1.0, 8.0, 1.5, 1.0, 3.5, 1.0, 0.0, 0.0, 0.0}, {4.5, 1.5, 8.0, 1.5, 0.5, 3.0, 1.0, 0.0, 0.0, 0.0}, {5.0, 1.5, 8.5, 1.0, 0.5, 3.0, 0.5, 0.0, 0.0, 0.0}, {5.5, 2.0, 8.0, 1.0, 0.0, 3.0, 0.5, 0.0, 0.0, 0.0}, {6.0, 2.5, 7.5, 1.0, 0.0, 2.5, 0.5, 0.0, 0.0, 0.0}, {6.5, 3.0, 7.0, 1.0, 0.0, 2.5, 0.0, 0.0, 0.0, 0.0}, {7.0, 3.5, 7.0, 0.5, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {7.5, 4.0, 6.0, 0.5, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {8.0, 4.5, 5.5, 0.5, 0.0, 1.5, 0.0, 0.0, 0.0, 0.0}, {9.0, 5.0, 4.5, 0.0, 0.0, 1.5, 0.0, 0.0, 0.0, 0.0}, {10.0, 5.5, 3.5, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {11.0, 6.0, 2.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {12.0, 6.5, 0.5, 0.0, 0.0, 0.5, 0.5, 0.0, 0.0, 0.0}, {12.0, 6.5, 0.5, 0.0, 0.0, 0.5, 0.5, 0.0, 0.0, 0.0}, {11.5, 6.0, 1.5, 0.0, 0.0, 0.5, 0.5, 0.0, 0.0, 0.0}, {10.0, 5.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}, {9.5, 5.5, 2.5, 0.5, 0.0, 1.5, 0.5, 0.0, 0.0, 0.0}, {9.0, 5.0, 3.5, 0.5, 0.0, 1.5, 0.5, 0.0, 0.0, 0.0}, {9.0, 4.0, 2.5, 1.0, 0.0, 2.5, 1.0, 0.0, 0.0, 0.0}, {8.5, 4.0, 2.5, 1.5, 0.0, 2.5, 1.0, 0.0, 0.0, 0.0}, {8.0, 3.0, 3.0, 1.5, 0.5, 3.0, 1.0, 0.0, 0.0, 0.0}, {7.0, 2.5, 3.5, 1.5, 1.0, 3.5, 1.0, 0.0, 0.0, 0.0}, {6.0, 2.0, 4.5, 1.5, 1.5, 3.5, 1.0, 0.0, 0.0, 0.0}, {5.0, 1.0, 6.0, 1.5, 1.5, 4.0, 1.0, 0.0, 0.0, 0.0}, {4.0, 1.0, 7.0, 1.5, 1.5, 3.5, 1.5, 0.0, 0.0, 0.0}};
        changesPerDay = 3.7;
        master = 1.0;
        timeScale = 1.75;
        weathers = new net.risingworld.api.objects.Weather[]{net.risingworld.api.objects.Weather.Default, net.risingworld.api.objects.Weather.Clear, net.risingworld.api.objects.Weather.Overcast, net.risingworld.api.objects.Weather.Fog, net.risingworld.api.objects.Weather.DenseFog, net.risingworld.api.objects.Weather.Rain, net.risingworld.api.objects.Weather.RainThunder, net.risingworld.api.objects.Weather.HeavyRain, net.risingworld.api.objects.Weather.HeavyRainThunder, net.risingworld.api.objects.Weather.Storm};
    }

    public void onEnable() {
        server = this.getServer();
        server.setWeatherEnabled(false);
        server.setWeather(net.risingworld.api.objects.Weather.Default, true);
        this.initSettings();
        double wholeDay = timeScale * 60.0 * 24.0;
        float cycle = (float)(wholeDay / changesPerDay);
        if (cycle < 70.0f) {
            cycle = 70.0f;
            System.out.println("WEATHER plug-in: short weather cycle raised to the min of 70.0 seconds.");
        }
        if (master > 1.0E-4) {
            timer = new Timer(cycle, cycle, -1, (Runnable)new WeatherTask());
            timer.start();
        }
        System.out.println("WEATHER 0.1.1 enabled successfully!");
    }

    public void onDisable() {
        timer.kill();
        timer = null;
        System.out.println("WEATHER 0.1.1 disabled successfully!");
    }

    private void initSettings() {
        String strLocale;
        String val = server.getOption("settings_time_speed");
        timeScale = Double.parseDouble(val);
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(in);
            in.close();
            changesPerDay = Weather.propertyToDouble(settings, "changesPerDay", 3.7);
            master = Weather.propertyToDouble(settings, "master", 1.0);
            if (master < 0.0) {
                master = 0.0;
                System.out.println("WEATHER plug-in: too low master setting raised to min (0.0).");
            }
            if (master > 1.0) {
                master = 1.0;
                System.out.println("WEATHER plug-in: too high master setting lowered to max (1.0).");
            }
            int i = 0;
            while (i < 24) {
                Weather.propertyToWeatherPeriodData(settings, i);
                ++i;
            }
            strLocale = settings.getProperty("locale", localeLanguageDef);
        }
        catch (IOException e) {
            strLocale = localeLanguageDef;
        }
        String[] localeParams = strLocale.split("-");
        locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
    }

    static void propertyToWeatherPeriodData(Properties settings, int periodIdx) {
        int i;
        String txt = settings.getProperty("period" + (periodIdx + 1));
        if (txt != null) {
            String[] data = txt.split(",");
            i = 0;
            while (i < data.length && i < 10) {
                try {
                    Weather.weatherProb[periodIdx][i] = Double.parseDouble(data[i]);
                }
                catch (NumberFormatException e) {
                    Weather.weatherProb[periodIdx][i] = 0.0;
                }
                ++i;
            }
        }
        double scale = 0.0;
        i = 0;
        while (i < 10) {
            scale += weatherProb[periodIdx][i];
            ++i;
        }
        double[] dArray = weatherProb[periodIdx];
        dArray[0] = dArray[0] / scale;
        i = 1;
        while (i < 10) {
            Weather.weatherProb[periodIdx][i] = weatherProb[periodIdx][i - 1] + weatherProb[periodIdx][i] / scale;
            ++i;
        }
    }

    static double propertyToDouble(Properties settings, String txt, double defaultVal) {
        double val;
        String txtVal = settings.getProperty(txt);
        if (txtVal == null) {
            return defaultVal;
        }
        try {
            val = Double.parseDouble(txtVal);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
        return val;
    }

    public class WeatherTask
    implements Runnable {
        private net.risingworld.api.objects.Weather prevWeather = net.risingworld.api.objects.Weather.Default;

        @Override
        public void run() {
            Time time = server.getGameTime();
            int month = time.getMonth() - 1;
            int day = time.getDay() - 1;
            int yearDay = monthToYd[month] + day;
            int weatherPeriod = yearDay / 15;
            double rand = Math.random() * master;
            int i = 0;
            while (i < 10) {
                if (rand <= weatherProb[weatherPeriod][i]) {
                    if (weathers[i] == this.prevWeather) break;
                    server.setWeather(weathers[i], false);
                    this.prevWeather = weathers[i];
                    break;
                }
                ++i;
            }
        }
    }
}

