/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.Car;
import de.galveston01.simple.car.CarThread;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.SimpleCar;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.WorldElement;

public class ScrollBoxGui
extends GUI {
    public SimpleCar plugin;
    public GuiPanel panel;
    public GuiLabel tenter;
    public GuiLabel trefuel;
    public GuiLabel trepair;
    public GuiLabel tlock;
    public Car car;
    public Player p;
    public int cari = 0;

    public ScrollBoxGui(Car car, Player p, int cari, SimpleCar plugin) {
        this.car = car;
        this.p = p;
        this.cari = cari;
        this.plugin = plugin;
        this.initGUI();
        this.addGUI();
    }

    @Override
    public void initGUI() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.15f, 0.3f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(0x90909CC);
        this.tenter = new GuiLabel(0.5f, 0.6125f, true);
        this.tenter.setPivot(PivotPosition.Center);
        this.tenter.setText(this.p == this.car.driver ? "leave" : "enter");
        this.tenter.setFontColor(-1);
        this.tenter.setClickable(true);
        this.tenter.setFontSize(35);
        this.trefuel = new GuiLabel(0.5f, 0.5375f, true);
        this.trefuel.setPivot(PivotPosition.Center);
        this.trefuel.setText("refuel");
        this.trefuel.setFontColor(-1);
        this.trefuel.setClickable(true);
        this.trefuel.setFontSize(35);
        this.trepair = new GuiLabel(0.5f, 0.4625f, true);
        this.trepair.setPivot(PivotPosition.Center);
        this.trepair.setText("repair");
        this.trepair.setFontColor(-1);
        this.trepair.setClickable(true);
        this.trepair.setFontSize(35);
        this.tlock = new GuiLabel(0.5f, 0.3875f, true);
        this.tlock.setPivot(PivotPosition.Center);
        this.tlock.setText(this.car.locked ? "unlock" : "lock");
        this.tlock.setFontColor(-1);
        this.tlock.setClickable(true);
        this.tlock.setFontSize(35);
    }

    @Override
    public void addGUI() {
        this.plugin.registerEventListener(this);
        this.p.setMouseCursorVisible(true);
        this.p.disableClientsideKeys(new int[]{33});
        this.p.setListenForKeyInput(true);
        this.p.addGuiElement((GuiElement)this.panel);
        this.p.addGuiElement((GuiElement)this.tenter);
        this.p.addGuiElement((GuiElement)this.trefuel);
        this.p.addGuiElement((GuiElement)this.trepair);
        this.p.addGuiElement((GuiElement)this.tlock);
    }

    @Override
    public void removeGUI() {
        this.p.setMouseCursorVisible(false);
        this.p.enableClientsideKeys(new int[]{33});
        this.plugin.unregisterEventListener(this);
        this.p.removeGuiElement((GuiElement)this.panel);
        this.p.removeGuiElement((GuiElement)this.tenter);
        this.p.removeGuiElement((GuiElement)this.trefuel);
        this.p.removeGuiElement((GuiElement)this.trepair);
        this.p.removeGuiElement((GuiElement)this.tlock);
        this.p.enableClientsideKeys(new int[]{33});
    }

    public void updateLock() {
        this.tlock.setText(this.car.locked ? "unlock" : "lock");
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (evt.getGuiElement() == this.tenter) {
                if (this.car.driver == this.p) {
                    if (this.plugin.cnf.message_carenter_global) {
                        this.plugin.getServer().broadcastTextMessage("[#0000ff]" + this.p.getName() + " left car (" + this.cari + ")!");
                    }
                    if (this.plugin.cnf.message_carenter_private) {
                        this.p.sendTextMessage("[#0000ff]left car (" + this.cari + ")!");
                    }
                    this.removeGUI();
                    float r = this.car.model.getRotation().toAngles()[1];
                    float lx = this.car.model.getPosition().x - (float)((double)this.car.cmodel.leavex * Math.cos(r) - (double)this.car.cmodel.leavez * Math.sin(r));
                    float lz = this.car.model.getPosition().z + (float)((double)this.car.cmodel.leavex * Math.sin(r) + (double)this.car.cmodel.leavez * Math.cos(r));
                    this.p.setPosition(lx, this.car.model.getPosition().y - (1.1f + this.car.cmodel.ycorrect + 0.3f) + 1.0f + this.car.cmodel.leavey, lz);
                    this.p.enableClientsideKeys(new int[]{17, 30, 31, 32, 57, 200, 203, 208, 205, 15, 60, 29});
                    this.p.setListenForKeyInput(false);
                    this.p.removeGuiElement((GuiElement)this.plugin.bgSpeedometer);
                    this.p.removeGuiElement((GuiElement)this.plugin.iFuel);
                    this.p.removeGuiElement((GuiElement)this.plugin.iLive);
                    this.car.hideGUI();
                    this.car.model.setCollisionShape(CollisionShape.createHullCollisionShape());
                    this.car.driver.setFlying(false);
                    this.car.driver = null;
                    this.car.thread.interrupt();
                } else {
                    if (this.car.locked) {
                        this.p.sendTextMessage("[#ff0000]Unable to enter a locked car!");
                        return;
                    }
                    if (this.plugin.cnf.carenter == Config.Perm.NONE) {
                        this.p.sendTextMessage("[#ff0000]Disabled on this server!");
                        return;
                    }
                    if (this.plugin.cnf.carenter == Config.Perm.ADMIN && !this.p.isAdmin()) {
                        this.p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                        return;
                    }
                    this.removeGUI();
                    if (this.plugin.cnf.message_carenter_global) {
                        this.plugin.getServer().broadcastTextMessage("[#0000ff]" + this.p.getName() + " entered car (" + this.cari + ")!");
                    }
                    if (this.plugin.cnf.message_carenter_private) {
                        this.p.sendTextMessage("[#0000ff]entered car (" + this.cari + ")!");
                    }
                    this.car.driver = this.p;
                    this.car.driver.setFlying(true);
                    this.car.model.setCollisionShape(null);
                    this.car.thread = new CarThread(this.car, this.plugin);
                    float r = this.car.model.getRotation().toAngles()[1];
                    float driverx = this.car.model.getPosition().x - (float)((double)this.car.cmodel.driverx * Math.cos(r) - (double)this.car.cmodel.driverz * Math.sin(r));
                    float driverz = this.car.model.getPosition().z + (float)((double)this.car.cmodel.driverx * Math.sin(r) + (double)this.car.cmodel.driverz * Math.cos(r));
                    this.p.setPosition(driverx, this.car.model.getPosition().y + this.car.cmodel.drivery, driverz);
                    float[] modelRotation = this.car.model.getRotation().toAngles();
                    modelRotation[0] = modelRotation[0] + Utils.MathUtils.degreeToRadian((float)30.0f);
                    modelRotation[1] = modelRotation[1] - Utils.MathUtils.degreeToRadian((float)90.0f);
                    this.p.setRotation(modelRotation[0], modelRotation[1], modelRotation[2]);
                    this.p.disableClientsideKeys(new int[]{17, 30, 31, 32, 57, 200, 203, 208, 205, 15, 60, 29});
                    this.p.setListenForKeyInput(true);
                    this.p.addGuiElement((GuiElement)this.plugin.bgSpeedometer);
                    this.p.addGuiElement((GuiElement)this.plugin.iFuel);
                    this.p.addGuiElement((GuiElement)this.plugin.iLive);
                    this.car.showGUI();
                    this.car.thread.start();
                }
            } else if (evt.getGuiElement() == this.trefuel) {
                if (this.plugin.cnf.refuelME == Config.Perm.NONE) {
                    this.p.sendTextMessage("[#ff0000]Disabled on this server!");
                    return;
                }
                if (this.plugin.cnf.refuelME == Config.Perm.ADMIN && !this.p.isAdmin()) {
                    this.p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                    return;
                }
                this.car.fuel = this.car.cmodel.maxfuel;
                this.car.updateFuel();
                this.p.sendTextMessage("[#0000ff]Car successfully refueled!");
            } else if (evt.getGuiElement() == this.trepair) {
                if (this.plugin.cnf.repairME == Config.Perm.NONE) {
                    this.p.sendTextMessage("[#ff0000]Disabled on this server!");
                    return;
                }
                if (this.plugin.cnf.repairME == Config.Perm.ADMIN && !this.p.isAdmin()) {
                    this.p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                    return;
                }
                this.car.live = this.car.cmodel.maxlive;
                this.car.updateLive();
                if (this.plugin.cnf.textlive3d) {
                    for (Player player : this.plugin.getServer().getAllPlayers()) {
                        if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
                        player.removeWorldElement((WorldElement)this.plugin.cars.get((int)this.cari).textLive);
                    }
                }
                this.p.sendTextMessage("[#0000ff]Car successfully repaired!");
            } else if (evt.getGuiElement() == this.tlock) {
                if (this.plugin.cnf.lockME == Config.Perm.NONE) {
                    this.p.sendTextMessage("[#ff0000]Disabled on this server!");
                    return;
                }
                if (this.plugin.cnf.lockME == Config.Perm.ADMIN && !this.p.isAdmin()) {
                    this.p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                    return;
                }
                if (this.p != this.car.owner) {
                    this.p.sendTextMessage("[#0000ff]You cannot lock an other players car!");
                    return;
                }
                this.car.locked = !this.car.locked;
                this.p.sendTextMessage("[#0000ff]Car " + (this.car.locked ? "locked" : "unlocked") + "!");
                this.updateLock();
            }
        }
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getKeyCode() == 33) {
            this.removeGUI();
        }
    }
}

