/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.CarInfoGui;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.SimpleCar;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class ModelListGui
extends GUI {
    public SimpleCar plugin;
    public Player p;
    public GuiPanel panel;
    public GuiLabel[] labels;
    public GuiLabel[] labelsid;
    public GuiLabel[] labelsown;
    public GuiPanel[] pclicks;
    public GuiLabel lnext;
    public GuiLabel llast;
    public int page;

    public ModelListGui(Player p, SimpleCar plugin) {
        if (plugin.cnf.modellist == Config.Perm.NONE) {
            p.sendTextMessage("[#ff0000]Disabled on this server!");
            return;
        }
        if (plugin.cnf.modellist == Config.Perm.ADMIN && !p.isAdmin()) {
            p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
            return;
        }
        this.plugin = plugin;
        this.p = p;
        this.initGUI();
        this.addGUI();
    }

    @Override
    public void initGUI() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(0x90909CC);
        this.labels = new GuiLabel[24];
        this.labelsid = new GuiLabel[24];
        this.labelsown = new GuiLabel[24];
        this.pclicks = new GuiPanel[24];
        for (int i = 0; i < 24; ++i) {
            GuiPanel pclick = new GuiPanel(0.16f + (float)(i / 12) * 0.4f, 0.805f - (float)(i % 12) * 0.043f, true, 0.3f, 0.035f, true);
            pclick.setColor(0);
            pclick.setPivot(PivotPosition.TopLeft);
            pclick.setClickable(true);
            GuiLabel l = new GuiLabel(0.21f + (float)(i / 12) * 0.4f, 0.8f - (float)(i % 12) * 0.043f, true);
            l.setPivot(PivotPosition.TopLeft);
            l.setClickable(true);
            GuiLabel lid = new GuiLabel(0.16f + (float)(i / 12) * 0.4f, 0.8f - (float)(i % 12) * 0.043f, true);
            lid.setPivot(PivotPosition.TopLeft);
            lid.setClickable(false);
            GuiLabel lown = new GuiLabel(0.31f + (float)(i / 12) * 0.4f, 0.8f - (float)(i % 12) * 0.043f, true);
            lown.setFontColor(-16776961);
            lown.setPivot(PivotPosition.TopLeft);
            lown.setClickable(false);
            if (i < this.plugin.cars.size()) {
                l.setText(this.plugin.cars.get((int)i).cmodel.name);
                lid.setText(this.page * 24 + i + ")");
                lown.setText(this.plugin.cars.get((int)(this.page * 24 + i)).owner.getName());
            } else {
                l.setText(" ");
                lid.setText(" ");
                lown.setText(" ");
            }
            this.labels[i] = l;
            this.labelsid[i] = lid;
            this.labelsown[i] = lown;
            this.pclicks[i] = pclick;
        }
        this.llast = new GuiLabel(0.2f, 0.22f, true);
        this.llast.setPivot(PivotPosition.Center);
        this.llast.setFontColor(-16776961);
        this.llast.setText("<-PREVIOUS");
        this.llast.setClickable(true);
        this.lnext = new GuiLabel(0.8f, 0.22f, true);
        this.lnext.setPivot(PivotPosition.Center);
        this.lnext.setFontColor(-16776961);
        this.lnext.setText("NEXT->");
        this.lnext.setClickable(true);
    }

    @Override
    public void addGUI() {
        this.plugin.registerEventListener(this);
        this.p.setMouseCursorVisible(true);
        this.p.disableClientsideKeys(new int[]{1});
        this.p.setListenForKeyInput(true);
        this.p.addGuiElement((GuiElement)this.panel);
        int i = 0;
        for (GuiLabel l : this.labels) {
            if (!l.getText().equals(" ")) {
                this.p.addGuiElement((GuiElement)l);
                this.p.addGuiElement((GuiElement)this.labelsid[i]);
                this.p.addGuiElement((GuiElement)this.labelsown[i]);
                this.p.addGuiElement((GuiElement)this.pclicks[i]);
            }
            ++i;
        }
        this.p.addGuiElement((GuiElement)this.llast);
        this.p.addGuiElement((GuiElement)this.lnext);
    }

    @Override
    public void removeGUI() {
        this.p.setMouseCursorVisible(false);
        this.p.enableClientsideKeys(new int[]{1});
        this.plugin.unregisterEventListener(this);
        this.p.removeGuiElement((GuiElement)this.panel);
        int i = 0;
        for (GuiLabel l : this.labels) {
            if (!l.getText().equals(" ")) {
                this.p.removeGuiElement((GuiElement)l);
                this.p.removeGuiElement((GuiElement)this.labelsid[i]);
                this.p.removeGuiElement((GuiElement)this.labelsown[i]);
                this.p.removeGuiElement((GuiElement)this.pclicks[i]);
            }
            ++i;
        }
        this.p.removeGuiElement((GuiElement)this.llast);
        this.p.removeGuiElement((GuiElement)this.lnext);
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getKeyCode() == 1) {
            this.removeGUI();
        }
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (this.llast == evt.getGuiElement()) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                }
                this.updatePage();
            } else if (this.lnext == evt.getGuiElement()) {
                ++this.page;
                if (this.page > this.plugin.cars.size() / 24) {
                    this.page = this.plugin.cars.size() / 24;
                }
                this.updatePage();
            } else {
                int i = 0;
                for (GuiPanel pn : this.pclicks) {
                    if (pn == evt.getGuiElement()) {
                        this.removeGUI();
                        new CarInfoGui(this.plugin, this.p, Integer.parseInt(this.labelsid[i].getText().substring(0, this.labelsid[i].getText().length() - 1)), this);
                    }
                    ++i;
                }
            }
        }
    }

    public void updatePage() {
        for (int i = 0; i < 24; ++i) {
            if (this.page * 24 + i < this.plugin.cars.size()) {
                this.labels[i].setText(this.plugin.cars.get((int)(this.page * 24 + i)).cmodel.name);
                this.labelsid[i].setText(this.page * 24 + i + ")");
                this.labelsown[i].setText(this.plugin.cars.get((int)i).owner.getName());
                continue;
            }
            this.labels[i].setText(" ");
            this.labelsid[i].setText(" ");
            this.labelsown[i].setText(" ");
        }
    }
}

