/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.SimpleCar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.risingworld.api.objects.Player;

public class CarModel {
    public String name;
    public float maxfuel = 100.0f;
    public float fuelconsumption = 1.0f;
    public float maxlive = 100.0f;
    public float livetexty = 3.0f;
    public float xcorrect = 0.0f;
    public float ycorrect = 0.0f;
    public float zcorrect = 0.0f;
    public float maxbps = 6.0f;
    public float maxdps;
    public float tc = 12.0f;
    public float driverx = 0.0f;
    public float drivery = 0.0f;
    public float driverz = 0.0f;
    public float leavex = 0.0f;
    public float leavey = 0.0f;
    public float leavez = 0.0f;
    public float accelbps = 3.0f;
    public float backbps = 2.0f;
    public float brakebps = 4.0f;
    public float frictionbps = 0.25f;
    public float bounce = 0.25f;
    public float mass = 1000.0f;
    public float frontx = 0.0f;
    public float frontz = 0.0f;
    public float backx = 0.0f;
    public float backz = 0.0f;
    public float height = 3.0f;
    public String smodel;
    public String stexture;
    public float scale = 1.0f;
    public float rxcorrect = 0.0f;
    public float rycorrect = 0.0f;
    public float rzcorrect = 0.0f;
    public boolean lighting_enabled = true;

    public CarModel() {
    }

    public CarModel(String name, float maxbps, float tc, float driverx, float drivery, float driverz, float accelbps, float backbps, float brakebps, float frictionbps, float maxlive, float livetexty, float maxfuel, float fuelconsumption, float bounce, float mass, float height, float frontx, float frontz, float backx, float backz, float ycorrect, float leavex, float leavey, float leavez) {
        this.name = name;
        this.maxbps = maxbps;
        this.driverx = driverx;
        this.drivery = drivery;
        this.driverz = driverz;
        this.leavex = leavex;
        this.leavey = leavey;
        this.leavez = leavez;
        this.ycorrect = ycorrect;
        this.tc = tc;
        this.maxlive = maxlive;
        this.livetexty = livetexty;
        this.maxfuel = maxfuel;
        this.fuelconsumption = fuelconsumption;
        this.bounce = bounce;
        this.mass = mass;
        this.height = height;
        this.frontx = frontx;
        this.frontz = frontz;
        this.backx = backx;
        this.backz = backz;
        this.accelbps = accelbps;
        this.backbps = backbps;
        this.brakebps = brakebps;
        this.frictionbps = frictionbps;
        this.maxdps = 360.0f / (tc / maxbps);
    }

    public void read(String name, SimpleCar plugin, Player p) {
        this.name = name;
        File carfile = new File(plugin.getPath() + "/assets/" + name + ".car");
        if (!carfile.exists()) {
            p.sendTextMessage("[#ff0000]GIVEN CAR TYPE DOESN'T EXIST!");
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(carfile));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] sp = line.split(":");
                if (sp.length != 2) continue;
                switch (sp[0]) {
                    case "model": {
                        this.smodel = sp[1];
                        break;
                    }
                    case "texture": {
                        this.stexture = sp[1];
                        break;
                    }
                    case "scale": {
                        this.scale = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "driverx": {
                        this.driverx = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "drivery": {
                        this.drivery = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "driverz": {
                        this.driverz = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "leavex": {
                        this.leavex = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "leavey": {
                        this.leavey = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "leavez": {
                        this.leavez = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "xcorrect": {
                        this.xcorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "ycorrect": {
                        this.ycorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "zcorrect": {
                        this.zcorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "rxcorrect": {
                        this.rxcorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "rycorrect": {
                        this.rycorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "rzcorrect": {
                        this.rzcorrect = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "maxbps": {
                        this.maxbps = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "tc": {
                        this.tc = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "tr": {
                        this.tc = (float)Math.PI * 2 * Float.parseFloat(sp[1]);
                        break;
                    }
                    case "td": {
                        this.tc = (float)Math.PI * Float.parseFloat(sp[1]);
                        break;
                    }
                    case "accelbps": {
                        this.accelbps = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "backbps": {
                        this.backbps = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "brakebps": {
                        this.brakebps = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "frictionbps": {
                        this.frictionbps = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "live": {
                        this.maxlive = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "livetexty": {
                        this.livetexty = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "fuel": {
                        this.maxfuel = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "fuelconsumption": {
                        this.fuelconsumption = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "bounce": {
                        this.bounce = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "mass": {
                        this.mass = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "height": {
                        this.height = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "frontx": {
                        this.frontx = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "frontz": {
                        this.frontz = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "backx": {
                        this.backx = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "backz": {
                        this.backz = Float.parseFloat(sp[1]);
                        break;
                    }
                    case "lighting_enabled": {
                        if (sp[1].equals("true")) {
                            this.lighting_enabled = true;
                            break;
                        }
                        if (!sp[1].equals("false")) break;
                        this.lighting_enabled = false;
                    }
                }
            }
        }
        catch (IOException ex) {
            p.sendTextMessage("UNABLE TO READ GIVEN CAR TYPES PROPERTIES!");
            return;
        }
    }
}

