/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.CarModel;
import de.galveston01.simple.car.CarmodelInfoGui;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.SimpleCar;
import java.io.File;
import java.util.ArrayList;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class CarListGui
extends GUI {
    public SimpleCar plugin;
    public Player p;
    public GuiPanel panel;
    public GuiLabel[] labels;
    public GuiLabel lnext;
    public GuiLabel llast;
    public int page;
    public ArrayList<String> cartypes;

    public CarListGui(Player p, SimpleCar plugin) {
        if (plugin.cnf.carlist == Config.Perm.NONE) {
            p.sendTextMessage("[#ff0000]Disabled on this server!");
            return;
        }
        if (plugin.cnf.carlist == Config.Perm.ADMIN && !p.isAdmin()) {
            p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
            return;
        }
        this.plugin = plugin;
        this.p = p;
        this.cartypes = new ArrayList();
        for (File f : new File(plugin.getPath() + "/assets/").listFiles()) {
            if (!f.getName().endsWith(".car")) continue;
            this.cartypes.add(f.getName().substring(0, f.getName().length() - 4));
        }
        this.initGUI();
        this.addGUI();
    }

    @Override
    public void initGUI() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(0x90909CC);
        this.labels = new GuiLabel[20];
        for (int i = 0; i < 20; ++i) {
            GuiLabel l = new GuiLabel(0.33f * (float)(i / 10 + 1), 0.75f - (float)(i % 10) * 0.05f, true);
            l.setPivot(PivotPosition.Center);
            l.setClickable(true);
            if (i < this.cartypes.size()) {
                l.setText(this.cartypes.get(i));
            } else {
                l.setText(" ");
            }
            this.labels[i] = l;
        }
        this.llast = new GuiLabel(0.2f, 0.22f, true);
        this.llast.setPivot(PivotPosition.Center);
        this.llast.setFontColor(-16776961);
        this.llast.setText("<-PREVIOUS");
        this.llast.setClickable(true);
        this.lnext = new GuiLabel(0.8f, 0.22f, true);
        this.lnext.setPivot(PivotPosition.Center);
        this.lnext.setFontColor(-16776961);
        this.lnext.setText("NEXT->");
        this.lnext.setClickable(true);
    }

    @Override
    public void addGUI() {
        this.plugin.registerEventListener(this);
        this.p.setMouseCursorVisible(true);
        this.p.disableClientsideKeys(new int[]{1});
        this.p.setListenForKeyInput(true);
        this.p.addGuiElement((GuiElement)this.panel);
        for (GuiLabel l : this.labels) {
            if (l.getText().equals(" ")) continue;
            this.p.addGuiElement((GuiElement)l);
        }
        this.p.addGuiElement((GuiElement)this.llast);
        this.p.addGuiElement((GuiElement)this.lnext);
    }

    @Override
    public void removeGUI() {
        this.p.setMouseCursorVisible(false);
        this.p.enableClientsideKeys(new int[]{1});
        this.plugin.unregisterEventListener(this);
        this.p.removeGuiElement((GuiElement)this.panel);
        for (GuiLabel l : this.labels) {
            if (l.getText().equals(" ")) continue;
            this.p.removeGuiElement((GuiElement)l);
        }
        this.p.removeGuiElement((GuiElement)this.llast);
        this.p.removeGuiElement((GuiElement)this.lnext);
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getKeyCode() == 1) {
            this.removeGUI();
        }
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (this.llast == evt.getGuiElement()) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                }
                this.updatePage();
            } else if (this.lnext == evt.getGuiElement()) {
                ++this.page;
                if (this.page > this.cartypes.size() / 20) {
                    this.page = this.cartypes.size() / 20;
                }
                this.updatePage();
            } else {
                for (GuiLabel l : this.labels) {
                    if (evt.getGuiElement() != l) continue;
                    this.removeGUI();
                    CarModel cm = new CarModel();
                    cm.read(l.getText(), this.plugin, this.p);
                    new CarmodelInfoGui(this.plugin, this.p, cm, this);
                }
            }
        }
    }

    public void updatePage() {
        for (int i = 0; i < 20; ++i) {
            if (this.page * 20 + i < this.cartypes.size()) {
                this.labels[i].setText(this.cartypes.get(this.page * 20 + i));
                continue;
            }
            this.labels[i].setText(" ");
        }
    }
}

