/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.Car;
import de.galveston01.simple.car.CarmodelInfoGui;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.SimpleCar;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class CarInfoGui
extends GUI {
    public SimpleCar plugin;
    public Player p;
    public int id;
    public Car c;
    public GUI parent;
    public GuiPanel panel;
    public GuiLabel lname;
    public GuiLabel lid;
    public GuiLabel lowner;
    public GuiLabel ldriver;
    public GuiLabel lfuel;
    public GuiLabel llive;
    public GuiLabel llocked;
    public GuiLabel lposition;
    public GuiLabel cname;
    public GuiLabel cid;
    public GuiLabel cowner;
    public GuiLabel cdriver;
    public GuiLabel cfuel;
    public GuiLabel clive;
    public GuiLabel clocked;
    public GuiLabel cposition;
    public GuiLabel bback;
    public GuiLabel bgoto;

    public CarInfoGui(SimpleCar plugin, Player p, int id, GUI parent) {
        if (plugin.cnf.carinfo == Config.Perm.NONE) {
            p.sendTextMessage("[#ff0000]Disabled on this server!");
            parent.addGUI();
            return;
        }
        if (plugin.cnf.carinfo == Config.Perm.ADMIN && !p.isAdmin()) {
            p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
            parent.addGUI();
            return;
        }
        this.plugin = plugin;
        this.p = p;
        this.id = id;
        this.c = plugin.cars.get(id);
        this.parent = parent;
        this.initGUI();
        this.addGUI();
    }

    @Override
    public void initGUI() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(0x90909CC);
        this.lname = new GuiLabel(0.33f, 0.75f, true);
        this.lname.setPivot(PivotPosition.Center);
        this.lname.setFontColor(-1);
        this.lname.setText("model name");
        this.cname = new GuiLabel(0.67f, 0.75f, true);
        this.cname.setPivot(PivotPosition.Center);
        this.cname.setFontColor(65535);
        this.cname.setText(this.c.cmodel.name);
        this.cname.setClickable(true);
        this.lid = new GuiLabel(0.33f, 0.7f, true);
        this.lid.setPivot(PivotPosition.Center);
        this.lid.setFontColor(-1);
        this.lid.setText("id");
        this.cid = new GuiLabel(0.67f, 0.7f, true);
        this.cid.setPivot(PivotPosition.Center);
        this.cid.setFontColor(-1);
        this.cid.setText(Integer.toString(this.id));
        this.lowner = new GuiLabel(0.33f, 0.65f, true);
        this.lowner.setPivot(PivotPosition.Center);
        this.lowner.setFontColor(-1);
        this.lowner.setText("owner");
        this.cowner = new GuiLabel(0.67f, 0.65f, true);
        this.cowner.setPivot(PivotPosition.Center);
        this.cowner.setFontColor(-1);
        this.cowner.setText(this.c.owner.getName());
        this.ldriver = new GuiLabel(0.33f, 0.6f, true);
        this.ldriver.setPivot(PivotPosition.Center);
        this.ldriver.setFontColor(-1);
        this.ldriver.setText("driver");
        this.cdriver = new GuiLabel(0.67f, 0.6f, true);
        this.cdriver.setPivot(PivotPosition.Center);
        this.cdriver.setFontColor(-1);
        this.cdriver.setText(this.c.driver == null ? "-" : this.c.driver.getName());
        this.lfuel = new GuiLabel(0.33f, 0.55f, true);
        this.lfuel.setPivot(PivotPosition.Center);
        this.lfuel.setFontColor(-1);
        this.lfuel.setText("fuel");
        this.cfuel = new GuiLabel(0.67f, 0.55f, true);
        this.cfuel.setPivot(PivotPosition.Center);
        this.cfuel.setFontColor(-1);
        this.cfuel.setText(this.c.fuel + "/" + this.c.cmodel.maxfuel + " -- " + (this.c.fuel + 0.0f) / this.c.cmodel.maxfuel * 100.0f + "%");
        this.llive = new GuiLabel(0.33f, 0.5f, true);
        this.llive.setPivot(PivotPosition.Center);
        this.llive.setFontColor(-1);
        this.llive.setText("live");
        this.clive = new GuiLabel(0.67f, 0.5f, true);
        this.clive.setPivot(PivotPosition.Center);
        this.clive.setFontColor(-1);
        this.clive.setText(this.c.live + "/" + this.c.cmodel.maxlive + " -- " + (this.c.live + 0.0f) / this.c.cmodel.maxlive * 100.0f + "%");
        this.llocked = new GuiLabel(0.33f, 0.45f, true);
        this.llocked.setPivot(PivotPosition.Center);
        this.llocked.setFontColor(-1);
        this.llocked.setText("locked?");
        this.clocked = new GuiLabel(0.67f, 0.45f, true);
        this.clocked.setPivot(PivotPosition.Center);
        this.clocked.setFontColor(-1);
        this.clocked.setText(this.c.locked ? "true" : "false");
        this.lposition = new GuiLabel(0.33f, 0.4f, true);
        this.lposition.setPivot(PivotPosition.Center);
        this.lposition.setFontColor(-1);
        this.lposition.setText("position");
        this.cposition = new GuiLabel(0.67f, 0.4f, true);
        this.cposition.setPivot(PivotPosition.Center);
        this.cposition.setFontColor(-1);
        this.cposition.setText(this.c.model.getPosition().toString());
        this.bgoto = new GuiLabel(0.7f, 0.375f, true);
        this.bgoto.setPivot(PivotPosition.Center);
        this.bgoto.setFontColor(-16776961);
        this.bgoto.setFontSize(16);
        this.bgoto.setClickable(true);
        this.bgoto.setText("(go there)");
        this.bback = new GuiLabel(0.13f, 0.85f, true);
        this.bback.setPivot(PivotPosition.Center);
        this.bback.setFontColor(-16776961);
        this.bback.setFontSize(45);
        this.bback.setClickable(true);
        this.bback.setText("<-");
    }

    @Override
    public void addGUI() {
        this.plugin.registerEventListener(this);
        this.p.setMouseCursorVisible(true);
        this.p.disableClientsideKeys(new int[]{1});
        this.p.disableClientsideKeys(new int[]{14});
        this.p.setListenForKeyInput(true);
        this.p.addGuiElement((GuiElement)this.panel);
        this.p.addGuiElement((GuiElement)this.lname);
        this.p.addGuiElement((GuiElement)this.cname);
        this.p.addGuiElement((GuiElement)this.lid);
        this.p.addGuiElement((GuiElement)this.cid);
        this.p.addGuiElement((GuiElement)this.lowner);
        this.p.addGuiElement((GuiElement)this.cowner);
        this.p.addGuiElement((GuiElement)this.ldriver);
        this.p.addGuiElement((GuiElement)this.cdriver);
        this.p.addGuiElement((GuiElement)this.lfuel);
        this.p.addGuiElement((GuiElement)this.cfuel);
        this.p.addGuiElement((GuiElement)this.llive);
        this.p.addGuiElement((GuiElement)this.clive);
        this.p.addGuiElement((GuiElement)this.llocked);
        this.p.addGuiElement((GuiElement)this.clocked);
        this.p.addGuiElement((GuiElement)this.lposition);
        this.p.addGuiElement((GuiElement)this.cposition);
        this.p.addGuiElement((GuiElement)this.bgoto);
        this.p.addGuiElement((GuiElement)this.bback);
    }

    @Override
    public void removeGUI() {
        this.p.setMouseCursorVisible(false);
        this.p.enableClientsideKeys(new int[]{1});
        this.p.enableClientsideKeys(new int[]{14});
        this.plugin.unregisterEventListener(this);
        this.p.removeGuiElement((GuiElement)this.panel);
        this.p.removeGuiElement((GuiElement)this.lname);
        this.p.removeGuiElement((GuiElement)this.cname);
        this.p.removeGuiElement((GuiElement)this.lid);
        this.p.removeGuiElement((GuiElement)this.cid);
        this.p.removeGuiElement((GuiElement)this.lowner);
        this.p.removeGuiElement((GuiElement)this.cowner);
        this.p.removeGuiElement((GuiElement)this.ldriver);
        this.p.removeGuiElement((GuiElement)this.cdriver);
        this.p.removeGuiElement((GuiElement)this.lfuel);
        this.p.removeGuiElement((GuiElement)this.cfuel);
        this.p.removeGuiElement((GuiElement)this.llive);
        this.p.removeGuiElement((GuiElement)this.clive);
        this.p.removeGuiElement((GuiElement)this.llocked);
        this.p.removeGuiElement((GuiElement)this.clocked);
        this.p.removeGuiElement((GuiElement)this.lposition);
        this.p.removeGuiElement((GuiElement)this.cposition);
        this.p.removeGuiElement((GuiElement)this.bgoto);
        this.p.removeGuiElement((GuiElement)this.bback);
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getKeyCode() == 1) {
            this.removeGUI();
        } else if (evt.getKeyCode() == 14) {
            this.removeGUI();
            this.parent.addGUI();
        }
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p) {
            if (evt.getGuiElement() == this.bback) {
                this.removeGUI();
                this.parent.addGUI();
            } else if (evt.getGuiElement() == this.bgoto) {
                if (this.plugin.cnf.gotocar == Config.Perm.NONE) {
                    this.p.sendTextMessage("[#ff0000]Disabled on this server!");
                    return;
                }
                if (this.plugin.cnf.gotocar == Config.Perm.ADMIN && !this.p.isAdmin()) {
                    this.p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                    return;
                }
                this.removeGUI();
                this.p.setPosition(new Vector3f(this.c.model.getPosition()));
            } else if (evt.getGuiElement() == this.cname) {
                this.removeGUI();
                new CarmodelInfoGui(this.plugin, this.p, this.c.cmodel, this);
            }
        }
    }
}

