/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.Car;
import de.galveston01.simple.car.CarModel;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.PlayerListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class SimpleCar
extends Plugin {
    public ArrayList<Car> cars = new ArrayList();
    public Config cnf;
    public GuiImage bgSpeedometer;
    public GuiImage iLive;
    public GuiImage iFuel;

    public void onEnable() {
        File fcars;
        this.cnf = new Config(new File(this.getPath() + "/Config.txt"));
        this.registerEventListener(new PlayerListener(this));
        if (this.cnf.bkup && (fcars = new File(this.getPath() + "/bkup/" + this.getWorld().getName() + ".cars")).exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(fcars));
                while ((line = br.readLine()) != null) {
                    String name = line;
                    String l = br.readLine();
                    Player owner = null;
                    for (Player p : this.getServer().getAllPlayers()) {
                        if (!p.getName().equals(l)) continue;
                        owner = p;
                        break;
                    }
                    float px = Float.parseFloat(br.readLine());
                    float py = Float.parseFloat(br.readLine());
                    float pz = Float.parseFloat(br.readLine());
                    float r = Float.parseFloat(br.readLine());
                    float fuel = Float.parseFloat(br.readLine());
                    float live = Float.parseFloat(br.readLine());
                    boolean locked = br.readLine().equals("1");
                    this.createNewCarModel(name, owner, px, py, pz, r, false);
                    this.cars.get((int)(this.cars.size() - 1)).model.setPosition(px, py, pz);
                    this.cars.get((int)(this.cars.size() - 1)).model.setRotation(new Quaternion().fromAngles(0.0f, r, 0.0f));
                    this.cars.get((int)(this.cars.size() - 1)).fuel = fuel;
                    this.cars.get((int)(this.cars.size() - 1)).live = live;
                    this.cars.get((int)(this.cars.size() - 1)).locked = locked;
                    this.cars.get(this.cars.size() - 1).updateFuel();
                    if (!(this.cars.get((int)(this.cars.size() - 1)).live < this.cars.get((int)(this.cars.size() - 1)).cmodel.maxlive) || !this.cnf.textlive3d) continue;
                    this.cars.get(this.cars.size() - 1).updateLive();
                    for (Player player : this.getServer().getAllPlayers()) {
                        if (!this.getServer().isPlayerConnected(player.getName())) continue;
                        player.addWorldElement((WorldElement)this.cars.get((int)(this.cars.size() - 1)).textLive);
                    }
                }
                br.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            ImageInformation bg_speedometer = new ImageInformation(this.getPath() + "/bg_speedometer.png");
            this.bgSpeedometer = new GuiImage(bg_speedometer, 0.35f, 0.2f, true, 0.3f, 0.2f, true);
            this.bgSpeedometer.setPivot(PivotPosition.TopLeft);
            ImageInformation screwdriver = new ImageInformation(this.getPath() + "/screwdriver.png");
            this.iLive = new GuiImage(screwdriver, 0.325f, 0.125f, true, 1.0f, 1.0f, true);
            this.iLive.setWidthProportional(0.035f, true);
            this.iLive.setPivot(PivotPosition.TopLeft);
            ImageInformation gasstation = new ImageInformation(this.getPath() + "/gasstation.png");
            this.iFuel = new GuiImage(gasstation, 0.325f, 0.195f, true, 1.0f, 1.0f, true);
            this.iFuel.setWidthProportional(0.035f, true);
            this.iFuel.setPivot(PivotPosition.TopLeft);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.cnf.autobkup > 0) {
            Timer tAutosave = new Timer((float)this.cnf.autobkup, 0.0f, -1, () -> {
                this.save();
                if (this.cnf.autobkup_message) {
                    this.getServer().broadcastTextMessage("[#0000ff]Saved cars!");
                }
            });
            tAutosave.start();
        }
    }

    public void onDisable() {
        this.save();
    }

    public void save() {
        if (this.cnf.bkup) {
            File fcars;
            if (!new File(this.getPath() + "/bkup").exists()) {
                new File(this.getPath() + "/bkup").mkdirs();
            }
            if (!(fcars = new File(this.getPath() + "/bkup/" + this.getWorld().getName() + ".cars")).exists()) {
                try {
                    fcars.createNewFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(fcars));
                for (Car c : this.cars) {
                    bw.write(c.cmodel.name + "\n");
                    bw.write(c.owner.getName() + "\n");
                    bw.write(c.model.getPosition().getX() + "\n");
                    bw.write(c.model.getPosition().getY() + "\n");
                    bw.write(c.model.getPosition().getZ() + "\n");
                    bw.write(c.model.getRotation().toAngles()[1] + "\n");
                    bw.write(c.fuel + "\n");
                    bw.write(c.live + "\n");
                    bw.write(c.locked ? "1" : "0\n");
                }
                bw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createNewCarModel(String name, Player p, float x, float y, float z, float r, boolean newCreated) {
        CarModel cm = new CarModel();
        cm.read(name, this, p);
        if (cm.smodel == null || cm.stexture == null) {
            p.sendTextMessage("UNABLE TO LOAD MODEL OR TEXTURE!");
            return;
        }
        if (!new File(this.getPath() + "/assets/" + cm.smodel).exists() || !new File(this.getPath() + "/assets/" + cm.stexture).exists()) {
            p.sendTextMessage("UNABLE TO LOAD MODEL OR TEXTURE!");
            return;
        }
        try {
            ModelInformation model = new ModelInformation(this.getPath() + "/assets/" + cm.smodel);
            ImageInformation texture = new ImageInformation(this.getPath() + "/assets/" + cm.stexture);
            World3DModel carModel = new World3DModel(model, texture);
            carModel.setLightingEnabled(cm.lighting_enabled);
            carModel.setInteractable(true);
            carModel.setInteractionCrosshair(Crosshair.Door);
            carModel.setCollisionShape(CollisionShape.createHullCollisionShape());
            carModel.setScale(cm.scale);
            if (newCreated) {
                carModel.setPosition(x + cm.xcorrect, y + cm.ycorrect, z + cm.zcorrect);
                carModel.setRotation(Utils.MathUtils.degreeToRadian((float)cm.rxcorrect), Utils.MathUtils.degreeToRadian((float)(r + cm.rycorrect)), Utils.MathUtils.degreeToRadian((float)cm.rzcorrect));
            }
            carModel.setHittable(true);
            Car car = new Car(carModel, p, cm);
            this.cars.add(car);
            for (Player player : this.getServer().getAllPlayers()) {
                if (!this.getServer().isPlayerConnected(player.getName())) continue;
                player.addWorldElement((WorldElement)carModel);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void decreaseLive(Car car, float l) {
        car.live -= l;
        car.updateLive();
        if (this.cnf.textlive3d) {
            for (Player player : this.getServer().getAllPlayers()) {
                if (!this.getServer().isPlayerConnected(player.getName())) continue;
                player.addWorldElement((WorldElement)car.textLive);
            }
        }
        if (car.live <= 0.0f) {
            this.destroyCar(car);
        }
    }

    public void destroyCar(Car car) {
        if (car.driver != null) {
            if (this.cnf.cardestroy_hitplayer) {
                Random rand = new Random();
                car.driver.setHealth(car.driver.getHealth() - rand.nextInt(100));
                if (!car.driver.isBleeding()) {
                    car.driver.setBleeding(rand.nextBoolean());
                }
                if (!car.driver.hasBrokenBones()) {
                    car.driver.setBrokenBones(rand.nextBoolean());
                }
            }
            car.driver.setPosition(car.model.getPosition().x, car.model.getPosition().y - (1.1f + car.cmodel.ycorrect + 0.3f) + car.cmodel.leavey, car.model.getPosition().z);
            car.model.setCollisionShape(CollisionShape.createHullCollisionShape());
            car.driver.enableClientsideKeys(new int[]{17, 30, 31, 32, 57, 200, 203, 208, 205, 15, 60, 29});
            car.driver.setListenForKeyInput(false);
            car.driver.removeGuiElement((GuiElement)this.bgSpeedometer);
            car.driver.removeGuiElement((GuiElement)this.iFuel);
            car.driver.removeGuiElement((GuiElement)this.iLive);
            car.hideGUI();
            car.thread.interrupt();
            if (!car.driver.isDead()) {
                final Player player = this.getServer().getPlayer(car.driver.getName());
                player.setFlying(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        float[] r;
                        for (int i = 0; i < 18; ++i) {
                            r = player.getRotation().toAngles();
                            r[0] = r[0] + Utils.MathUtils.degreeToRadian((float)((18 - i) * 5 / 9));
                            player.setRotation(r[0], r[1], r[2]);
                            try {
                                Thread.sleep(20L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        for (int i = 1; i <= 18; ++i) {
                            r = player.getRotation().toAngles();
                            r[0] = r[0] - Utils.MathUtils.degreeToRadian((float)(i * 5 / 9));
                            r[1] = r[1] - Utils.MathUtils.degreeToRadian((float)((float)i * 2.5f / 9.0f));
                            player.setRotation(r[0], r[1], r[2]);
                            player.setPosition(player.getPosition().x, player.getPosition().y + 0.055555556f, player.getPosition().z);
                            try {
                                Thread.sleep(40L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }).start();
            }
        }
        this.cars.remove(car);
        for (Player player : this.getServer().getAllPlayers()) {
            if (!this.getServer().isPlayerConnected(player.getName())) continue;
            player.removeWorldElement((WorldElement)car.model);
        }
        if (this.cnf.textlive3d) {
            for (Player player : this.getServer().getAllPlayers()) {
                if (!this.getServer().isPlayerConnected(player.getName())) continue;
                player.removeWorldElement((WorldElement)car.textLive);
            }
        }
    }
}

