/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.Car;
import de.galveston01.simple.car.CarInfoGui;
import de.galveston01.simple.car.CarListGui;
import de.galveston01.simple.car.CarModel;
import de.galveston01.simple.car.CarmodelInfoGui;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.ModelListGui;
import de.galveston01.simple.car.ScrollBoxGui;
import de.galveston01.simple.car.SimpleCar;
import java.util.ArrayList;
import java.util.Iterator;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class PlayerListener
implements Listener {
    private SimpleCar plugin;

    public PlayerListener(SimpleCar plugin) {
        this.plugin = plugin;
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerConnect(PlayerConnectEvent evt) {
        Player p = evt.getPlayer();
        int[] keys = evt.getPlayer().getRegisteredKeys();
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (keys != null) {
            for (int key : keys) {
                l.add(key);
            }
        }
        if (!l.contains(17)) {
            l.add(17);
        }
        if (!l.contains(30)) {
            l.add(30);
        }
        if (!l.contains(31)) {
            l.add(31);
        }
        if (!l.contains(32)) {
            l.add(32);
        }
        if (!l.contains(57)) {
            l.add(57);
        }
        if (!l.contains(200)) {
            l.add(200);
        }
        if (!l.contains(203)) {
            l.add(203);
        }
        if (!l.contains(205)) {
            l.add(205);
        }
        if (!l.contains(208)) {
            l.add(208);
        }
        if (!l.contains(60)) {
            l.add(60);
        }
        if (!l.contains(15)) {
            l.add(15);
        }
        if (!l.contains(29)) {
            l.add(29);
        }
        if (!l.contains(33)) {
            l.add(33);
        }
        if (!l.contains(1)) {
            l.add(1);
        }
        if (!l.contains(14)) {
            l.add(14);
        }
        int[] li = new int[l.size()];
        int i = 0;
        Iterator<Object> iterator = l.iterator();
        while (iterator.hasNext()) {
            int s;
            li[i] = s = ((Integer)iterator.next()).intValue();
            ++i;
        }
        evt.getPlayer().registerKeys(li);
        if (this.plugin.cnf.textlive3d) {
            for (Car car : this.plugin.cars) {
                p.addWorldElement((WorldElement)car.model);
                if (!(car.live < car.cmodel.maxlive)) continue;
                p.addWorldElement((WorldElement)car.textLive);
            }
        }
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerDisconnect(PlayerConnectEvent evt) {
        Player p = evt.getPlayer();
        for (Car car : this.plugin.cars) {
            Player p1 = car.driver;
            if (p != p1) continue;
            car.driver = null;
        }
    }

    @EventMethod(value=Threading.Sync)
    public void onCommand(PlayerCommandEvent event) {
        String command = event.getCommand();
        if (command.equals("/car help")) {
            if (this.plugin.cnf.help == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.help == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            event.getPlayer().sendTextMessage("[#ff0000]ALLOWED SYNTAX");
            this.helpMessage(event.getPlayer());
        } else if (command.equals("/car list")) {
            new CarListGui(event.getPlayer(), this.plugin);
        } else if (command.equals("/car getid")) {
            if (this.plugin.cnf.getid == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.getid == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            int i = 0;
            for (Car c : this.plugin.cars) {
                if (event.getPlayer() == c.driver) {
                    c.driver.sendTextMessage("[#0000ff]You're driving car (" + i + ")");
                    return;
                }
                ++i;
            }
            event.getPlayer().sendTextMessage("[#0000ff]You aren't driving a car!");
        } else if (command.equals("/car listall")) {
            new ModelListGui(event.getPlayer(), this.plugin);
        } else if (command.equals("/car refuel")) {
            if (this.plugin.cnf.refuelME == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.refuelME == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            for (Car c : this.plugin.cars) {
                if (event.getPlayer() != c.driver) continue;
                c.fuel = c.cmodel.maxfuel;
                c.updateFuel();
                event.getPlayer().sendTextMessage("[#0000ff]Car successfully refueled!");
                return;
            }
            event.getPlayer().sendTextMessage("[#ff0000]You aren't driving a car!");
        } else if (command.equals("/car repair")) {
            if (this.plugin.cnf.repairME == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.repairME == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            for (Car c : this.plugin.cars) {
                if (event.getPlayer() != c.driver) continue;
                c.live = c.cmodel.maxlive;
                c.updateLive();
                if (this.plugin.cnf.textlive3d) {
                    for (Player player : this.plugin.getServer().getAllPlayers()) {
                        if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
                        player.removeWorldElement((WorldElement)c.textLive);
                    }
                }
                event.getPlayer().sendTextMessage("[#0000ff]Car successfully repaired!");
                return;
            }
            event.getPlayer().sendTextMessage("[#ff0000]You aren't driving a car!");
        } else if (command.equals("/car lock")) {
            if (this.plugin.cnf.lockME == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.lockME == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            for (Car c : this.plugin.cars) {
                if (event.getPlayer() != c.driver) continue;
                c.locked = !c.locked;
                event.getPlayer().sendTextMessage("[#0000ff]Car " + (c.locked ? "locked" : "unlocked") + "!");
                for (Player player : this.plugin.getServer().getAllPlayers()) {
                    if (player.getAttribute("sbg") == null || !(player.getAttribute("sbg") instanceof ScrollBoxGui)) continue;
                    ScrollBoxGui sbg = (ScrollBoxGui)player.getAttribute("sbg");
                    if (sbg.car != c) continue;
                    sbg.updateLock();
                }
                return;
            }
            event.getPlayer().sendTextMessage("[#ff0000]You aren't driving a car!");
        } else if (command.equals("/car save")) {
            if (this.plugin.cnf.save == Config.Perm.NONE) {
                event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.save == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            this.plugin.save();
        } else {
            String[] cmd = command.split(" ");
            if (cmd[0].equals("/car")) {
                if (cmd.length == 1) {
                    event.getPlayer().sendTextMessage("[#ff0000]NOT ENOUGH PARAMETERS!");
                    this.helpMessage(event.getPlayer());
                    return;
                }
                if (cmd.length == 2) {
                    if (this.plugin.cnf.carspawnME == Config.Perm.NONE) {
                        event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                        return;
                    }
                    if (this.plugin.cnf.carspawnME == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                        event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                        return;
                    }
                    Player p = event.getPlayer();
                    float[] r = p.getRotation().toAngles();
                    this.plugin.createNewCarModel(cmd[1], p, p.getPosition().x, p.getPosition().y, p.getPosition().z, Utils.MathUtils.radianToDegree((float)r[1]) + 90.0f, true);
                } else if (cmd.length == 3) {
                    if (cmd[2].startsWith("#")) {
                        String s = cmd[2].substring(1);
                        Object player = null;
                        for (Object p : this.plugin.getServer().getAllPlayers()) {
                            if (!p.getName().equals(s)) continue;
                            player = p;
                            break;
                        }
                        if (player == null) {
                            event.getPlayer().sendTextMessage("[#ff0000]PASSED PLAYER WASN'T FOUND!");
                            this.helpMessage(event.getPlayer());
                            return;
                        }
                        if (cmd[1].equals("owner")) {
                            int i = 0;
                            for (Car c : this.plugin.cars) {
                                if (c.driver == event.getPlayer()) {
                                    c.owner = player;
                                    event.getPlayer().sendTextMessage("[#0000ff]Changed Owner of car (" + i + ") to " + player.getName());
                                    return;
                                }
                                ++i;
                            }
                            event.getPlayer().sendTextMessage("[#0000ff]You aren't driving a car!");
                            return;
                        }
                        if (this.plugin.cnf.carspawnPLAYER == Config.Perm.NONE) {
                            event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                            return;
                        }
                        if (this.plugin.cnf.carspawnPLAYER == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                            return;
                        }
                        float[] r = player.getRotation().toAngles();
                        this.plugin.createNewCarModel(cmd[1], event.getPlayer(), player.getPosition().x, player.getPosition().y, player.getPosition().z, Utils.MathUtils.radianToDegree((float)r[1]) + 90.0f, true);
                    } else if (cmd[1].equals("goto")) {
                        if (this.plugin.cnf.gotocar == Config.Perm.NONE) {
                            event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                            return;
                        }
                        if (this.plugin.cnf.gotocar == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                            return;
                        }
                        if (Utils.StringUtils.isInteger((String)cmd[2])) {
                            int i = Integer.parseInt(cmd[2]);
                            event.getPlayer().setPosition(new Vector3f(this.plugin.cars.get((int)i).model.getPosition()));
                            event.getPlayer().sendTextMessage("[#0000ff]Went to car (" + i + ")");
                        } else {
                            event.getPlayer().sendTextMessage("[#ff0000]ID has to be numeric!");
                        }
                        return;
                    }
                    if (cmd[1].equals("info")) {
                        if (Utils.StringUtils.isInteger((String)cmd[2])) {
                            new CarInfoGui(this.plugin, event.getPlayer(), Integer.parseInt(cmd[2]), new GUI(){

                                @Override
                                public void initGUI() {
                                }

                                @Override
                                public void addGUI() {
                                }

                                @Override
                                public void removeGUI() {
                                }
                            });
                        } else {
                            CarModel c = new CarModel();
                            c.read(cmd[2], this.plugin, event.getPlayer());
                            new CarmodelInfoGui(this.plugin, event.getPlayer(), c, new GUI(){

                                @Override
                                public void initGUI() {
                                }

                                @Override
                                public void addGUI() {
                                }

                                @Override
                                public void removeGUI() {
                                }
                            });
                        }
                    } else if (cmd[1].equals("refuel")) {
                        if (this.plugin.cnf.refuelID == Config.Perm.NONE) {
                            event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                            return;
                        }
                        if (this.plugin.cnf.refuelID == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                            return;
                        }
                        int id = Integer.parseInt(cmd[2]);
                        if (id < this.plugin.cars.size()) {
                            this.plugin.cars.get((int)id).fuel = this.plugin.cars.get((int)id).cmodel.maxfuel;
                            this.plugin.cars.get(id).updateFuel();
                            event.getPlayer().sendTextMessage("[#0000ff]Car (" + id + ") successfully refueled!");
                        } else {
                            event.getPlayer().sendTextMessage("[#ff0000]Car (" + id + ") doesn't exist!");
                        }
                    } else if (cmd[1].equals("repair")) {
                        if (this.plugin.cnf.repairID == Config.Perm.NONE) {
                            event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                            return;
                        }
                        if (this.plugin.cnf.repairID == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                            return;
                        }
                        int id = Integer.parseInt(cmd[2]);
                        if (id < this.plugin.cars.size()) {
                            this.plugin.cars.get((int)id).live = this.plugin.cars.get((int)id).cmodel.maxlive;
                            this.plugin.cars.get(id).updateLive();
                            if (this.plugin.cnf.textlive3d) {
                                for (Player player : this.plugin.getServer().getAllPlayers()) {
                                    if (!this.plugin.getServer().isPlayerConnected(player.getName())) continue;
                                    player.removeWorldElement((WorldElement)this.plugin.cars.get((int)id).textLive);
                                }
                            }
                            event.getPlayer().sendTextMessage("[#0000ff]Car (" + id + ") successfully repaired!");
                        } else {
                            event.getPlayer().sendTextMessage("[#ff0000]Car (" + id + ") doesn't exist!");
                        }
                    } else if (cmd[1].equals("lock")) {
                        if (!event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                            return;
                        }
                        int id = Integer.parseInt(cmd[2]);
                        if (id < this.plugin.cars.size()) {
                            this.plugin.cars.get((int)id).locked = !this.plugin.cars.get((int)id).locked;
                            for (Player player : this.plugin.getServer().getAllPlayers()) {
                                if (player.getAttribute("sbg") == null || !(player.getAttribute("sbg") instanceof ScrollBoxGui)) continue;
                                ScrollBoxGui sbg = (ScrollBoxGui)player.getAttribute("sbg");
                                if (sbg.car != this.plugin.cars.get(id)) continue;
                                sbg.updateLock();
                            }
                            event.getPlayer().sendTextMessage("[#0000ff]Car " + (this.plugin.cars.get((int)id).locked ? "locked" : "unlocked") + "!");
                        } else {
                            event.getPlayer().sendTextMessage("[#ff0000]Car (" + id + ") doesn't exist!");
                        }
                    } else {
                        event.getPlayer().sendTextMessage("[#ff0000]Unknown car Command!");
                        this.helpMessage(event.getPlayer());
                    }
                } else if (cmd.length == 4) {
                    if (cmd[1].equals("owner") && cmd[3].startsWith("#")) {
                        String s = cmd[2].substring(1);
                        Player player = null;
                        for (Player p : this.plugin.getServer().getAllPlayers()) {
                            if (!p.getName().equals(s)) continue;
                            player = p;
                            break;
                        }
                        if (player == null) {
                            event.getPlayer().sendTextMessage("[#ff0000]PASSED PLAYER WASN'T FOUND!");
                            this.helpMessage(event.getPlayer());
                            return;
                        }
                        if (!event.getPlayer().isAdmin()) {
                            event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                        }
                        if (cmd[1].equals("owner")) {
                            int id = 0;
                            if (!Utils.StringUtils.isNumeric((String)cmd[2])) {
                                event.getPlayer().sendTextMessage("[#ff0000]ID PARAMETER HAS TO BE NUMERIC!");
                                return;
                            }
                            id = Integer.parseInt(cmd[2]);
                            if (id >= this.plugin.cars.size()) {
                                event.getPlayer().sendTextMessage("[#ff0000]Car (" + id + ") doesn't exist!");
                            }
                            this.plugin.cars.get((int)id).owner = player;
                            event.getPlayer().sendTextMessage("[#0000ff]Changed Owner of car (" + id + ") to " + player.getName());
                            return;
                        }
                    }
                } else if (cmd.length == 5) {
                    if (this.plugin.cnf.carspawnPOSITION == Config.Perm.NONE) {
                        event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                        return;
                    }
                    if (this.plugin.cnf.carspawnPOSITION == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                        event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                        return;
                    }
                    if (Utils.StringUtils.isNumeric((String)cmd[2]) && Utils.StringUtils.isNumeric((String)cmd[3]) && Utils.StringUtils.isNumeric((String)cmd[4])) {
                        float px = Float.parseFloat(cmd[2]);
                        float py = Float.parseFloat(cmd[3]);
                        float pz = Float.parseFloat(cmd[4]);
                        this.plugin.createNewCarModel(cmd[1], event.getPlayer(), px, py, pz, 0.0f, true);
                    } else {
                        event.getPlayer().sendTextMessage("[#ff0000]PARAMETERS HAVE TO BE NUMBERS!");
                        this.helpMessage(event.getPlayer());
                    }
                } else if (cmd.length == 6) {
                    if (this.plugin.cnf.carspawnPOSITIONR == Config.Perm.NONE) {
                        event.getPlayer().sendTextMessage("[#ff0000]Disabled on this server!");
                        return;
                    }
                    if (this.plugin.cnf.carspawnPOSITIONR == Config.Perm.ADMIN && !event.getPlayer().isAdmin()) {
                        event.getPlayer().sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                        return;
                    }
                    if (Utils.StringUtils.isNumeric((String)cmd[2]) && Utils.StringUtils.isNumeric((String)cmd[3]) && Utils.StringUtils.isNumeric((String)cmd[4]) && Utils.StringUtils.isNumeric((String)cmd[5])) {
                        float px = Float.parseFloat(cmd[2]);
                        float py = Float.parseFloat(cmd[3]);
                        float pz = Float.parseFloat(cmd[4]);
                        float r = Float.parseFloat(cmd[5]);
                        this.plugin.createNewCarModel(cmd[1], event.getPlayer(), px, py, pz, r, true);
                    } else {
                        event.getPlayer().sendTextMessage("[#ff0000]PARAMETERS HAVE TO BE NUMBERS!");
                        this.helpMessage(event.getPlayer());
                    }
                } else {
                    event.getPlayer().sendTextMessage("[#ff0000]TOO MANY PARAMETERS!");
                    this.helpMessage(event.getPlayer());
                }
            }
        }
    }

    private void helpMessage(Player p) {
        p.sendTextMessage("\t /car help");
        p.sendTextMessage("\t /car [#0000ff]type");
        p.sendTextMessage("\t /car [#0000ff]type [#000000]#[#0000ff]player");
        p.sendTextMessage("\t /car [#0000ff]type x y z\t\t[#ffffff]/car [#0000ff]type x y z r");
        p.sendTextMessage("\t /car refuel \t\t /car refuel [#0000ff]id");
        p.sendTextMessage("\t /car repair \t\t /car repair [#0000ff]id");
        p.sendTextMessage("\t /car lock \t\t   /car lock [#0000ff]id");
        p.sendTextMessage("\t /car owner [#000000]#[#0000ff]player\t[#ffffff]/car owner [#0000ff]id [#000000]#[#0000ff]player");
        p.sendTextMessage("\t /car list\t\t/car listall");
        p.sendTextMessage("\t /car getid \t\t/car save");
        p.sendTextMessage("\t /car info [#0000ff]id\t\t[#ffffff]/car info [#0000ff]model");
        p.sendTextMessage("\t /car goto [#0000ff]id");
    }

    @EventMethod
    public void onPlayerElementHit(PlayerElementHitEvent evt) {
        Player p = evt.getPlayer();
        WorldElement element = evt.getWorldElement();
        for (Car car : this.plugin.cars) {
            World3DModel model = car.model;
            if (model != element) continue;
            if (this.plugin.cnf.carhit == Config.Perm.NONE) {
                p.sendTextMessage("[#ff0000]Disabled on this server!");
                return;
            }
            if (this.plugin.cnf.carhit == Config.Perm.ADMIN && !p.isAdmin()) {
                p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
                return;
            }
            if (!this.plugin.cnf.carlive) {
                this.plugin.destroyCar(car);
                return;
            }
            if (car.driver != null) {
                if (car.driver == p) {
                    p.sendTextMessage("[#0000ff]Why are you trying to destroy your own car?!");
                } else {
                    p.sendTextMessage("[#0000ff]Somebody is sitting in this car!" + (this.plugin.cnf.cardestroy_hitplayer ? " If you destroy it, he can get hurt!!!" : ""));
                    car.driver.sendTextMessage("[#0000ff]Somebody tries to destroy your car!" + (this.plugin.cnf.cardestroy_hitplayer ? "  If he's successful, you can get hurt!!!" : ""));
                }
            }
            this.plugin.decreaseLive(car, 40.0f);
            return;
        }
    }

    @EventMethod
    public void onPlayerInteract(PlayerElementInteractionEvent evt) {
        Player p = evt.getPlayer();
        WorldElement element = evt.getWorldElement();
        int i = 0;
        for (Car car : this.plugin.cars) {
            World3DModel model = car.model;
            if (model == element) {
                new ScrollBoxGui(car, p, i, this.plugin);
                return;
            }
            ++i;
        }
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        Player p = evt.getPlayer();
        Car car = null;
        for (Car c : this.plugin.cars) {
            if (c.driver != p) continue;
            car = c;
            break;
        }
        if (car != null) {
            if (evt.getKeyCode() == 17 || evt.getKeyCode() == 57 || evt.getKeyCode() == 200) {
                car.thread.w = evt.isPressed();
            } else if (evt.getKeyCode() == 30 || evt.getKeyCode() == 203) {
                car.thread.a = evt.isPressed();
            } else if (evt.getKeyCode() == 31 || evt.getKeyCode() == 208) {
                car.thread.s = evt.isPressed();
            } else if (evt.getKeyCode() == 32 || evt.getKeyCode() == 205) {
                car.thread.d = evt.isPressed();
            } else if (evt.getKeyCode() == 15) {
                if (evt.isPressed()) {
                    car.showInfoGUI();
                } else {
                    car.hideInfoGUI();
                }
            }
        }
    }
}

