/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.CarModel;
import de.galveston01.simple.car.CarThread;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.World3DText;

public class Car {
    public Player driver = null;
    public CarThread thread = null;
    public CarModel cmodel;
    public World3DModel model;
    public World3DText textLive = null;
    public Player owner;
    public float fuel = 100.0f;
    public float live = 100.0f;
    public boolean locked = false;
    private GuiPanel panelInfo;
    private GuiPanel bar;
    private GuiLabel lname;
    private GuiLabel lbps;
    private GuiLabel ltc;
    private GuiLabel ltr;
    private GuiLabel ldps;
    private GuiLabel laccelbps;
    private GuiLabel lbrakebps;
    private GuiLabel lbackbps;
    private GuiLabel lfrictionbps;
    private GuiLabel lfuelconsumption;
    private GuiLabel lmass;
    private GuiLabel lheight;
    private GuiLabel cname;
    private GuiLabel cbps;
    private GuiLabel ctc;
    private GuiLabel ctr;
    private GuiLabel cdps;
    private GuiLabel caccelbps;
    private GuiLabel cbrakebps;
    private GuiLabel cbackbps;
    private GuiLabel cfrictionbps;
    private GuiLabel cfuelconsumption;
    private GuiLabel cmass;
    private GuiLabel cheight;
    private GuiPanel hbar;
    private GuiLabel lspeed;
    private GuiLabel lrot;
    private GuiLabel cspeed;
    private GuiLabel crot;
    private GuiPanel liveBg;
    private GuiPanel liveFg;
    private GuiLabel llive;
    private GuiPanel fuelBg;
    private GuiPanel fuelFg;
    private GuiLabel lfuel;

    public Car(World3DModel model, Player spawner, CarModel cmodel) {
        this.model = model;
        this.owner = spawner;
        this.cmodel = cmodel;
        this.live = cmodel.maxlive;
        this.fuel = cmodel.maxfuel;
        this.initGUI();
        this.initInfoGUI();
        this.textLive = new World3DText("[#006aff](" + cmodel.maxlive + "/" + cmodel.maxlive + ")");
        this.textLive.setBillboard(true);
    }

    public void updateLive() {
        float sl = (float)((int)(this.live * 100.0f)) / 100.0f;
        float slmax = (float)((int)(this.cmodel.maxlive * 100.0f)) / 100.0f;
        this.textLive.setText("[#006aff](" + sl + "/" + slmax + ")");
        this.textLive.setPosition(this.model.getPosition().x, this.model.getPosition().y + this.cmodel.livetexty, this.model.getPosition().z);
        this.liveFg.setSize(0.3f * (this.live / this.cmodel.maxlive), 0.04f, true);
        this.llive.setText("(" + sl + "/" + slmax + ")");
    }

    public void updateFuel() {
        this.fuelFg.setSize(0.3f * (this.fuel / this.cmodel.maxfuel), 0.04f, true);
        this.lfuel.setText("(" + (float)((int)(this.fuel * 100.0f)) / 100.0f + "/" + (float)((int)(this.cmodel.maxfuel * 100.0f)) / 100.0f + ")");
    }

    private void initGUI() {
        this.hbar = new GuiPanel(0.499f, 0.2f, true, 0.002f, 0.2f, true);
        this.hbar.setPivot(PivotPosition.TopLeft);
        this.hbar.setColor(255);
        this.lspeed = new GuiLabel(0.49f, 0.01f, true);
        this.lspeed.setPivot(PivotPosition.BottomRight);
        this.lspeed.setText("(bps)");
        this.lspeed.setFontColor(255);
        this.lspeed.setFontSize(32);
        this.cspeed = new GuiLabel(0.49f, 0.05f, true);
        this.cspeed.setPivot(PivotPosition.BottomRight);
        this.cspeed.setText("0.0");
        this.cspeed.setFontColor(255);
        this.cspeed.setFontSize(80);
        this.lrot = new GuiLabel(0.51f, 0.01f, true);
        this.lrot.setPivot(PivotPosition.BottomLeft);
        this.lrot.setText("(dps)");
        this.lrot.setFontColor(255);
        this.lrot.setFontSize(32);
        this.crot = new GuiLabel(0.51f, 0.05f, true);
        this.crot.setPivot(PivotPosition.BottomLeft);
        this.crot.setText("0.0");
        this.crot.setFontColor(255);
        this.crot.setFontSize(80);
        this.liveBg = new GuiPanel(0.005f, 0.125f, true, 0.31f, 0.05f, true);
        this.liveBg.setPivot(PivotPosition.TopLeft);
        this.liveBg.setColor(153);
        this.liveFg = new GuiPanel(0.008f, 0.12f, true, 0.3f, 0.04f, true);
        this.liveFg.setPivot(PivotPosition.TopLeft);
        this.liveFg.setColor(7012283);
        this.llive = new GuiLabel(0.16f, 0.1f, true);
        this.llive.setPivot(PivotPosition.Center);
        this.llive.setText("(" + (float)((int)(this.cmodel.maxlive * 100.0f)) / 100.0f + "/" + (float)((int)(this.cmodel.maxlive * 100.0f)) / 100.0f + ")");
        this.llive.setFontColor(-1);
        this.llive.setFontSize(32);
        this.fuelBg = new GuiPanel(0.005f, 0.195f, true, 0.31f, 0.05f, true);
        this.fuelBg.setPivot(PivotPosition.TopLeft);
        this.fuelBg.setColor(153);
        this.fuelFg = new GuiPanel(0.008f, 0.19f, true, 0.3f, 0.04f, true);
        this.fuelFg.setPivot(PivotPosition.TopLeft);
        this.fuelFg.setColor(0xFF00BB);
        this.lfuel = new GuiLabel(0.16f, 0.17f, true);
        this.lfuel.setPivot(PivotPosition.Center);
        this.lfuel.setText("(" + (float)((int)(this.cmodel.maxfuel * 100.0f)) / 100.0f + "/" + (float)((int)(this.cmodel.maxfuel * 100.0f)) / 100.0f + ")");
        this.lfuel.setFontColor(-1);
        this.lfuel.setFontSize(32);
    }

    public void updateGUI(float speed, float rot) {
        this.cspeed.setText(Float.toString((float)((int)(speed * 10.0f)) / 10.0f));
        this.crot.setText(Float.toString((float)((int)(rot * 10.0f)) / 10.0f));
    }

    public void showGUI() {
        this.driver.addGuiElement((GuiElement)this.hbar);
        this.driver.addGuiElement((GuiElement)this.lspeed);
        this.driver.addGuiElement((GuiElement)this.cspeed);
        this.driver.addGuiElement((GuiElement)this.lrot);
        this.driver.addGuiElement((GuiElement)this.crot);
        this.driver.addGuiElement((GuiElement)this.liveBg);
        this.driver.addGuiElement((GuiElement)this.liveFg);
        this.driver.addGuiElement((GuiElement)this.llive);
        this.driver.addGuiElement((GuiElement)this.fuelBg);
        this.driver.addGuiElement((GuiElement)this.fuelFg);
        this.driver.addGuiElement((GuiElement)this.lfuel);
    }

    public void hideGUI() {
        this.driver.removeGuiElement((GuiElement)this.hbar);
        this.driver.removeGuiElement((GuiElement)this.lspeed);
        this.driver.removeGuiElement((GuiElement)this.cspeed);
        this.driver.removeGuiElement((GuiElement)this.lrot);
        this.driver.removeGuiElement((GuiElement)this.crot);
        this.driver.removeGuiElement((GuiElement)this.liveBg);
        this.driver.removeGuiElement((GuiElement)this.liveFg);
        this.driver.removeGuiElement((GuiElement)this.llive);
        this.driver.removeGuiElement((GuiElement)this.fuelBg);
        this.driver.removeGuiElement((GuiElement)this.fuelFg);
        this.driver.removeGuiElement((GuiElement)this.lfuel);
    }

    private void initInfoGUI() {
        this.panelInfo = new GuiPanel(0.15f, 0.15f, true, 0.7f, 0.7f, true);
        this.panelInfo.setColor(136);
        this.panelInfo.setBorderColor(204);
        this.panelInfo.setVisible(true);
        this.panelInfo.setBorderThickness(0.005f, true);
        this.lname = new GuiLabel(0.2f, 0.8f, true);
        this.lname.setPivot(PivotPosition.TopLeft);
        this.lname.setText("type:");
        this.lname.setFontColor(-1);
        this.lname.setFontSize(32);
        this.cname = new GuiLabel(0.8f, 0.8f, true);
        this.cname.setPivot(PivotPosition.TopRight);
        this.cname.setText(this.cmodel.name);
        this.cname.setFontColor(-1);
        this.cname.setFontSize(32);
        this.bar = new GuiPanel(0.18f, 0.742f, true, 0.64f, 0.004f, true);
        this.bar.setPivot(PivotPosition.TopLeft);
        this.bar.setColor(255);
        this.lbps = new GuiLabel(0.2f, 0.7f, true);
        this.lbps.setPivot(PivotPosition.TopLeft);
        this.lbps.setText("max. speed:");
        this.lbps.setFontColor(-1);
        this.lbps.setFontSize(32);
        this.cbps = new GuiLabel(0.8f, 0.7f, true);
        this.cbps.setPivot(PivotPosition.TopRight);
        this.cbps.setText((float)((int)(this.cmodel.maxbps * 100.0f)) / 100.0f + " blocks per second");
        this.cbps.setFontColor(-1);
        this.cbps.setFontSize(32);
        this.ltc = new GuiLabel(0.2f, 0.65f, true);
        this.ltc.setPivot(PivotPosition.TopLeft);
        this.ltc.setText("min. turning cycle:");
        this.ltc.setFontColor(-1);
        this.ltc.setFontSize(32);
        this.ctc = new GuiLabel(0.8f, 0.65f, true);
        this.ctc.setPivot(PivotPosition.TopRight);
        this.ctc.setText((float)((int)(this.cmodel.tc * 100.0f)) / 100.0f + " blocks");
        this.ctc.setFontColor(-1);
        this.ctc.setFontSize(32);
        this.ltr = new GuiLabel(0.2f, 0.6f, true);
        this.ltr.setPivot(PivotPosition.TopLeft);
        this.ltr.setText("min. turning radius:");
        this.ltr.setFontColor(-1);
        this.ltr.setFontSize(32);
        this.ctr = new GuiLabel(0.8f, 0.6f, true);
        this.ctr.setPivot(PivotPosition.TopRight);
        this.ctr.setText((float)((int)((double)this.cmodel.tc / (Math.PI * 2) * 100.0)) / 100.0f + " blocks");
        this.ctr.setFontColor(-1);
        this.ctr.setFontSize(32);
        this.ldps = new GuiLabel(0.2f, 0.55f, true);
        this.ldps.setPivot(PivotPosition.TopLeft);
        this.ldps.setText("max. arc second:");
        this.ldps.setFontColor(-1);
        this.ldps.setFontSize(32);
        this.cdps = new GuiLabel(0.8f, 0.55f, true);
        this.cdps.setPivot(PivotPosition.TopRight);
        this.cdps.setText((float)((int)(this.cmodel.maxdps * 100.0f)) / 100.0f + " degrees per second");
        this.cdps.setFontColor(-1);
        this.cdps.setFontSize(32);
        this.laccelbps = new GuiLabel(0.2f, 0.5f, true);
        this.laccelbps.setPivot(PivotPosition.TopLeft);
        this.laccelbps.setText("acceleration:");
        this.laccelbps.setFontColor(-1);
        this.laccelbps.setFontSize(32);
        this.caccelbps = new GuiLabel(0.8f, 0.5f, true);
        this.caccelbps.setPivot(PivotPosition.TopRight);
        this.caccelbps.setText((float)((int)(this.cmodel.accelbps * 100.0f)) / 100.0f + " blocks per square second");
        this.caccelbps.setFontColor(-1);
        this.caccelbps.setFontSize(32);
        this.lbrakebps = new GuiLabel(0.2f, 0.45f, true);
        this.lbrakebps.setPivot(PivotPosition.TopLeft);
        this.lbrakebps.setText("brake acceleration:");
        this.lbrakebps.setFontColor(-1);
        this.lbrakebps.setFontSize(32);
        this.cbrakebps = new GuiLabel(0.8f, 0.45f, true);
        this.cbrakebps.setPivot(PivotPosition.TopRight);
        this.cbrakebps.setText((float)((int)(this.cmodel.brakebps * 100.0f)) / 100.0f + " blocks per square second");
        this.cbrakebps.setFontColor(-1);
        this.cbrakebps.setFontSize(32);
        this.lbackbps = new GuiLabel(0.2f, 0.4f, true);
        this.lbackbps.setPivot(PivotPosition.TopLeft);
        this.lbackbps.setText("max. backward speed:");
        this.lbackbps.setFontColor(-1);
        this.lbackbps.setFontSize(32);
        this.cbackbps = new GuiLabel(0.8f, 0.4f, true);
        this.cbackbps.setPivot(PivotPosition.TopRight);
        this.cbackbps.setText((float)((int)(this.cmodel.backbps * 100.0f)) / 100.0f + " blocks per second");
        this.cbackbps.setFontColor(-1);
        this.cbackbps.setFontSize(32);
        this.lfrictionbps = new GuiLabel(0.2f, 0.35f, true);
        this.lfrictionbps.setPivot(PivotPosition.TopLeft);
        this.lfrictionbps.setText("friction slowdown:");
        this.lfrictionbps.setFontColor(-1);
        this.lfrictionbps.setFontSize(32);
        this.cfrictionbps = new GuiLabel(0.8f, 0.35f, true);
        this.cfrictionbps.setPivot(PivotPosition.TopRight);
        this.cfrictionbps.setText((float)((int)(this.cmodel.frictionbps * 100.0f)) / 100.0f + " blocks per square second");
        this.cfrictionbps.setFontColor(-1);
        this.cfrictionbps.setFontSize(32);
        this.lfuelconsumption = new GuiLabel(0.2f, 0.3f, true);
        this.lfuelconsumption.setPivot(PivotPosition.TopLeft);
        this.lfuelconsumption.setText("fuel consumption (while accelerating):");
        this.lfuelconsumption.setFontColor(-1);
        this.lfuelconsumption.setFontSize(32);
        this.cfuelconsumption = new GuiLabel(0.8f, 0.3f, true);
        this.cfuelconsumption.setPivot(PivotPosition.TopRight);
        this.cfuelconsumption.setText((float)((int)(this.cmodel.fuelconsumption * 10.0f)) / 10.0f + " liter per block");
        this.cfuelconsumption.setFontColor(-1);
        this.cfuelconsumption.setFontSize(32);
        this.lmass = new GuiLabel(0.2f, 0.2f, true);
        this.lmass.setPivot(PivotPosition.TopLeft);
        this.lmass.setText("mass:");
        this.lmass.setFontColor(-1);
        this.lmass.setFontSize(32);
        this.cmass = new GuiLabel(0.8f, 0.2f, true);
        this.cmass.setPivot(PivotPosition.TopRight);
        this.cmass.setText(Float.toString(this.cmodel.mass) + " kilograms");
        this.cmass.setFontColor(-1);
        this.cmass.setFontSize(32);
        this.lheight = new GuiLabel(0.2f, 0.25f, true);
        this.lheight.setPivot(PivotPosition.TopLeft);
        this.lheight.setText("height:");
        this.lheight.setFontColor(-1);
        this.lheight.setFontSize(32);
        this.cheight = new GuiLabel(0.8f, 0.25f, true);
        this.cheight.setPivot(PivotPosition.TopRight);
        this.cheight.setText(Float.toString(this.cmodel.height) + " blocks");
        this.cheight.setFontColor(-1);
        this.cheight.setFontSize(32);
    }

    public void showInfoGUI() {
        this.driver.addGuiElement((GuiElement)this.panelInfo);
        this.driver.addGuiElement((GuiElement)this.bar);
        this.driver.addGuiElement((GuiElement)this.lname);
        this.driver.addGuiElement((GuiElement)this.cname);
        this.driver.addGuiElement((GuiElement)this.lbps);
        this.driver.addGuiElement((GuiElement)this.cbps);
        this.driver.addGuiElement((GuiElement)this.ltc);
        this.driver.addGuiElement((GuiElement)this.ctc);
        this.driver.addGuiElement((GuiElement)this.ltr);
        this.driver.addGuiElement((GuiElement)this.ctr);
        this.driver.addGuiElement((GuiElement)this.ldps);
        this.driver.addGuiElement((GuiElement)this.cdps);
        this.driver.addGuiElement((GuiElement)this.laccelbps);
        this.driver.addGuiElement((GuiElement)this.caccelbps);
        this.driver.addGuiElement((GuiElement)this.lbrakebps);
        this.driver.addGuiElement((GuiElement)this.cbrakebps);
        this.driver.addGuiElement((GuiElement)this.lbackbps);
        this.driver.addGuiElement((GuiElement)this.cbackbps);
        this.driver.addGuiElement((GuiElement)this.lfrictionbps);
        this.driver.addGuiElement((GuiElement)this.cfrictionbps);
        this.driver.addGuiElement((GuiElement)this.lfuelconsumption);
        this.driver.addGuiElement((GuiElement)this.cfuelconsumption);
        this.driver.addGuiElement((GuiElement)this.lmass);
        this.driver.addGuiElement((GuiElement)this.cmass);
        this.driver.addGuiElement((GuiElement)this.lheight);
        this.driver.addGuiElement((GuiElement)this.cheight);
    }

    public void hideInfoGUI() {
        this.driver.removeGuiElement((GuiElement)this.panelInfo);
        this.driver.removeGuiElement((GuiElement)this.bar);
        this.driver.removeGuiElement((GuiElement)this.lname);
        this.driver.removeGuiElement((GuiElement)this.cname);
        this.driver.removeGuiElement((GuiElement)this.lbps);
        this.driver.removeGuiElement((GuiElement)this.cbps);
        this.driver.removeGuiElement((GuiElement)this.ltc);
        this.driver.removeGuiElement((GuiElement)this.ctc);
        this.driver.removeGuiElement((GuiElement)this.ltr);
        this.driver.removeGuiElement((GuiElement)this.ctr);
        this.driver.removeGuiElement((GuiElement)this.ldps);
        this.driver.removeGuiElement((GuiElement)this.cdps);
        this.driver.removeGuiElement((GuiElement)this.laccelbps);
        this.driver.removeGuiElement((GuiElement)this.caccelbps);
        this.driver.removeGuiElement((GuiElement)this.lbrakebps);
        this.driver.removeGuiElement((GuiElement)this.cbrakebps);
        this.driver.removeGuiElement((GuiElement)this.lbackbps);
        this.driver.removeGuiElement((GuiElement)this.cbackbps);
        this.driver.removeGuiElement((GuiElement)this.lfrictionbps);
        this.driver.removeGuiElement((GuiElement)this.cfrictionbps);
        this.driver.removeGuiElement((GuiElement)this.lfuelconsumption);
        this.driver.removeGuiElement((GuiElement)this.cfuelconsumption);
        this.driver.removeGuiElement((GuiElement)this.lmass);
        this.driver.removeGuiElement((GuiElement)this.cmass);
        this.driver.removeGuiElement((GuiElement)this.lheight);
        this.driver.removeGuiElement((GuiElement)this.cheight);
    }
}

