/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.CarModel;
import de.galveston01.simple.car.Config;
import de.galveston01.simple.car.GUI;
import de.galveston01.simple.car.SimpleCar;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class CarmodelInfoGui
extends GUI {
    public SimpleCar plugin;
    public Player p;
    public int id;
    public CarModel cm;
    public GUI parent;
    public GuiPanel panel;
    public GuiLabel lname;
    public GuiLabel lbps;
    public GuiLabel ltc;
    public GuiLabel ltr;
    public GuiLabel ldps;
    public GuiLabel laccelbps;
    public GuiLabel lbrakebps;
    public GuiLabel lbackbps;
    public GuiLabel lfrictionbps;
    public GuiLabel lfuelconsumption;
    public GuiLabel lmass;
    public GuiLabel lheight;
    public GuiLabel cname;
    public GuiLabel cbps;
    public GuiLabel ctc;
    public GuiLabel ctr;
    public GuiLabel cdps;
    public GuiLabel caccelbps;
    public GuiLabel cbrakebps;
    public GuiLabel cbackbps;
    public GuiLabel cfrictionbps;
    public GuiLabel cfuelconsumption;
    public GuiLabel cmass;
    public GuiLabel cheight;
    public GuiLabel bback;

    public CarmodelInfoGui(SimpleCar plugin, Player p, CarModel cm, GUI parent) {
        if (plugin.cnf.carmodelinfo == Config.Perm.NONE) {
            p.sendTextMessage("[#ff0000]Disabled on this server!");
            parent.addGUI();
            return;
        }
        if (plugin.cnf.carmodelinfo == Config.Perm.ADMIN && !p.isAdmin()) {
            p.sendTextMessage("[#ff0000]Only admins are allowed to do that!");
            parent.addGUI();
            return;
        }
        this.plugin = plugin;
        this.p = p;
        this.id = this.id;
        this.cm = cm;
        this.parent = parent;
        this.initGUI();
        this.addGUI();
    }

    @Override
    public void initGUI() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(0x90909CC);
        this.lname = new GuiLabel(0.2f, 0.75f, true);
        this.lname.setPivot(PivotPosition.TopLeft);
        this.lname.setFontColor(-1);
        this.lname.setText("model name");
        this.lname.setFontSize(32);
        this.cname = new GuiLabel(0.8f, 0.75f, true);
        this.cname.setPivot(PivotPosition.TopRight);
        this.cname.setFontColor(-1);
        this.cname.setText(this.cm.name);
        this.cname.setFontSize(32);
        this.lbps = new GuiLabel(0.2f, 0.7f, true);
        this.lbps.setPivot(PivotPosition.TopLeft);
        this.lbps.setText("max. speed:");
        this.lbps.setFontColor(-1);
        this.lbps.setFontSize(32);
        this.cbps = new GuiLabel(0.8f, 0.7f, true);
        this.cbps.setPivot(PivotPosition.TopRight);
        this.cbps.setText((float)((int)(this.cm.maxbps * 100.0f)) / 100.0f + " blocks per second");
        this.cbps.setFontColor(-1);
        this.cbps.setFontSize(32);
        this.ltc = new GuiLabel(0.2f, 0.65f, true);
        this.ltc.setPivot(PivotPosition.TopLeft);
        this.ltc.setText("min. turning cycle:");
        this.ltc.setFontColor(-1);
        this.ltc.setFontSize(32);
        this.ctc = new GuiLabel(0.8f, 0.65f, true);
        this.ctc.setPivot(PivotPosition.TopRight);
        this.ctc.setText((float)((int)(this.cm.tc * 100.0f)) / 100.0f + " blocks");
        this.ctc.setFontColor(-1);
        this.ctc.setFontSize(32);
        this.ltr = new GuiLabel(0.2f, 0.6f, true);
        this.ltr.setPivot(PivotPosition.TopLeft);
        this.ltr.setText("min. turning radius:");
        this.ltr.setFontColor(-1);
        this.ltr.setFontSize(32);
        this.ctr = new GuiLabel(0.8f, 0.6f, true);
        this.ctr.setPivot(PivotPosition.TopRight);
        this.ctr.setText((float)((int)((double)this.cm.tc / (Math.PI * 2) * 100.0)) / 100.0f + " blocks");
        this.ctr.setFontColor(-1);
        this.ctr.setFontSize(32);
        this.ldps = new GuiLabel(0.2f, 0.55f, true);
        this.ldps.setPivot(PivotPosition.TopLeft);
        this.ldps.setText("max. arc second:");
        this.ldps.setFontColor(-1);
        this.ldps.setFontSize(32);
        this.cdps = new GuiLabel(0.8f, 0.55f, true);
        this.cdps.setPivot(PivotPosition.TopRight);
        this.cdps.setText((float)((int)(this.cm.maxdps * 100.0f)) / 100.0f + " degrees per second");
        this.cdps.setFontColor(-1);
        this.cdps.setFontSize(32);
        this.laccelbps = new GuiLabel(0.2f, 0.5f, true);
        this.laccelbps.setPivot(PivotPosition.TopLeft);
        this.laccelbps.setText("acceleration:");
        this.laccelbps.setFontColor(-1);
        this.laccelbps.setFontSize(32);
        this.caccelbps = new GuiLabel(0.8f, 0.5f, true);
        this.caccelbps.setPivot(PivotPosition.TopRight);
        this.caccelbps.setText((float)((int)(this.cm.accelbps * 100.0f)) / 100.0f + " blocks per square second");
        this.caccelbps.setFontColor(-1);
        this.caccelbps.setFontSize(32);
        this.lbrakebps = new GuiLabel(0.2f, 0.45f, true);
        this.lbrakebps.setPivot(PivotPosition.TopLeft);
        this.lbrakebps.setText("brake acceleration:");
        this.lbrakebps.setFontColor(-1);
        this.lbrakebps.setFontSize(32);
        this.cbrakebps = new GuiLabel(0.8f, 0.45f, true);
        this.cbrakebps.setPivot(PivotPosition.TopRight);
        this.cbrakebps.setText((float)((int)(this.cm.brakebps * 100.0f)) / 100.0f + " blocks per square second");
        this.cbrakebps.setFontColor(-1);
        this.cbrakebps.setFontSize(32);
        this.lbackbps = new GuiLabel(0.2f, 0.4f, true);
        this.lbackbps.setPivot(PivotPosition.TopLeft);
        this.lbackbps.setText("max. backward speed:");
        this.lbackbps.setFontColor(-1);
        this.lbackbps.setFontSize(32);
        this.cbackbps = new GuiLabel(0.8f, 0.4f, true);
        this.cbackbps.setPivot(PivotPosition.TopRight);
        this.cbackbps.setText((float)((int)(this.cm.backbps * 100.0f)) / 100.0f + " blocks per second");
        this.cbackbps.setFontColor(-1);
        this.cbackbps.setFontSize(32);
        this.lfrictionbps = new GuiLabel(0.2f, 0.35f, true);
        this.lfrictionbps.setPivot(PivotPosition.TopLeft);
        this.lfrictionbps.setText("friction slowdown:");
        this.lfrictionbps.setFontColor(-1);
        this.lfrictionbps.setFontSize(32);
        this.cfrictionbps = new GuiLabel(0.8f, 0.35f, true);
        this.cfrictionbps.setPivot(PivotPosition.TopRight);
        this.cfrictionbps.setText((float)((int)(this.cm.frictionbps * 100.0f)) / 100.0f + " blocks per square second");
        this.cfrictionbps.setFontColor(-1);
        this.cfrictionbps.setFontSize(32);
        this.lfuelconsumption = new GuiLabel(0.2f, 0.3f, true);
        this.lfuelconsumption.setPivot(PivotPosition.TopLeft);
        this.lfuelconsumption.setText("fuel consumption (while accelerating):");
        this.lfuelconsumption.setFontColor(-1);
        this.lfuelconsumption.setFontSize(32);
        this.cfuelconsumption = new GuiLabel(0.8f, 0.3f, true);
        this.cfuelconsumption.setPivot(PivotPosition.TopRight);
        this.cfuelconsumption.setText((float)((int)(this.cm.fuelconsumption * 10.0f)) / 10.0f + " liter per block");
        this.cfuelconsumption.setFontColor(-1);
        this.cfuelconsumption.setFontSize(32);
        this.lmass = new GuiLabel(0.2f, 0.2f, true);
        this.lmass.setPivot(PivotPosition.TopLeft);
        this.lmass.setText("mass:");
        this.lmass.setFontColor(-1);
        this.lmass.setFontSize(32);
        this.cmass = new GuiLabel(0.8f, 0.2f, true);
        this.cmass.setPivot(PivotPosition.TopRight);
        this.cmass.setText(Float.toString(this.cm.mass) + " kilograms");
        this.cmass.setFontColor(-1);
        this.cmass.setFontSize(32);
        this.lheight = new GuiLabel(0.2f, 0.25f, true);
        this.lheight.setPivot(PivotPosition.TopLeft);
        this.lheight.setText("height:");
        this.lheight.setFontColor(-1);
        this.lheight.setFontSize(32);
        this.cheight = new GuiLabel(0.8f, 0.25f, true);
        this.cheight.setPivot(PivotPosition.TopRight);
        this.cheight.setText(Float.toString(this.cm.height) + " blocks");
        this.cheight.setFontColor(-1);
        this.cheight.setFontSize(32);
        this.bback = new GuiLabel(0.13f, 0.85f, true);
        this.bback.setPivot(PivotPosition.Center);
        this.bback.setFontColor(-16776961);
        this.bback.setFontSize(45);
        this.bback.setClickable(true);
        this.bback.setText("<-");
    }

    @Override
    public void addGUI() {
        this.plugin.registerEventListener(this);
        this.p.setMouseCursorVisible(true);
        this.p.disableClientsideKeys(new int[]{1});
        this.p.disableClientsideKeys(new int[]{14});
        this.p.setListenForKeyInput(true);
        this.p.addGuiElement((GuiElement)this.panel);
        this.p.addGuiElement((GuiElement)this.lname);
        this.p.addGuiElement((GuiElement)this.cname);
        this.p.addGuiElement((GuiElement)this.lbps);
        this.p.addGuiElement((GuiElement)this.cbps);
        this.p.addGuiElement((GuiElement)this.ltc);
        this.p.addGuiElement((GuiElement)this.ctc);
        this.p.addGuiElement((GuiElement)this.ltr);
        this.p.addGuiElement((GuiElement)this.ctr);
        this.p.addGuiElement((GuiElement)this.ldps);
        this.p.addGuiElement((GuiElement)this.cdps);
        this.p.addGuiElement((GuiElement)this.laccelbps);
        this.p.addGuiElement((GuiElement)this.caccelbps);
        this.p.addGuiElement((GuiElement)this.lbrakebps);
        this.p.addGuiElement((GuiElement)this.cbrakebps);
        this.p.addGuiElement((GuiElement)this.lbackbps);
        this.p.addGuiElement((GuiElement)this.cbackbps);
        this.p.addGuiElement((GuiElement)this.lfrictionbps);
        this.p.addGuiElement((GuiElement)this.cfrictionbps);
        this.p.addGuiElement((GuiElement)this.lfuelconsumption);
        this.p.addGuiElement((GuiElement)this.cfuelconsumption);
        this.p.addGuiElement((GuiElement)this.lmass);
        this.p.addGuiElement((GuiElement)this.cmass);
        this.p.addGuiElement((GuiElement)this.lheight);
        this.p.addGuiElement((GuiElement)this.cheight);
        this.p.addGuiElement((GuiElement)this.bback);
    }

    @Override
    public void removeGUI() {
        this.p.setMouseCursorVisible(false);
        this.p.enableClientsideKeys(new int[]{1});
        this.p.enableClientsideKeys(new int[]{14});
        this.plugin.unregisterEventListener(this);
        this.p.removeGuiElement((GuiElement)this.panel);
        this.p.removeGuiElement((GuiElement)this.lname);
        this.p.removeGuiElement((GuiElement)this.cname);
        this.p.removeGuiElement((GuiElement)this.lbps);
        this.p.removeGuiElement((GuiElement)this.cbps);
        this.p.removeGuiElement((GuiElement)this.ltc);
        this.p.removeGuiElement((GuiElement)this.ctc);
        this.p.removeGuiElement((GuiElement)this.ltr);
        this.p.removeGuiElement((GuiElement)this.ctr);
        this.p.removeGuiElement((GuiElement)this.ldps);
        this.p.removeGuiElement((GuiElement)this.cdps);
        this.p.removeGuiElement((GuiElement)this.laccelbps);
        this.p.removeGuiElement((GuiElement)this.caccelbps);
        this.p.removeGuiElement((GuiElement)this.lbrakebps);
        this.p.removeGuiElement((GuiElement)this.cbrakebps);
        this.p.removeGuiElement((GuiElement)this.lbackbps);
        this.p.removeGuiElement((GuiElement)this.cbackbps);
        this.p.removeGuiElement((GuiElement)this.lfrictionbps);
        this.p.removeGuiElement((GuiElement)this.cfrictionbps);
        this.p.removeGuiElement((GuiElement)this.lfuelconsumption);
        this.p.removeGuiElement((GuiElement)this.cfuelconsumption);
        this.p.removeGuiElement((GuiElement)this.lmass);
        this.p.removeGuiElement((GuiElement)this.cmass);
        this.p.removeGuiElement((GuiElement)this.lheight);
        this.p.removeGuiElement((GuiElement)this.cheight);
        this.p.removeGuiElement((GuiElement)this.bback);
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getKeyCode() == 1) {
            this.removeGUI();
        } else if (evt.getKeyCode() == 14) {
            this.removeGUI();
            this.parent.addGUI();
        }
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.p && evt.getGuiElement() == this.bback) {
            this.removeGUI();
            this.parent.addGUI();
        }
    }
}

