/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.simple.car;

import de.galveston01.simple.car.Car;
import de.galveston01.simple.car.PhysicsThread;
import de.galveston01.simple.car.SimpleCar;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;

public class CarThread
extends Thread {
    private Car car;
    private SimpleCar plugin;
    public boolean w = false;
    public boolean a = false;
    public boolean s = false;
    public boolean d = false;
    public float fx;
    public float fz;
    public float fxr;
    public float fzr;
    public float speedFactor;
    public float speedFactorAccel;
    public float speedFactorBrake;
    public float speedFactorFriction;
    public float relmaxbps;
    public float relbackbps;
    private float rotationFactor;
    private float fuelc;
    private PhysicsThread tphysics;

    public CarThread(Car car, SimpleCar plugin) {
        this.car = car;
        this.plugin = plugin;
        this.speedFactorAccel = car.cmodel.accelbps * ((float)plugin.cnf.delta / 1000.0f) * ((float)plugin.cnf.delta / 1000.0f);
        this.speedFactorBrake = car.cmodel.brakebps * ((float)plugin.cnf.delta / 1000.0f) * ((float)plugin.cnf.delta / 1000.0f);
        this.speedFactorFriction = car.cmodel.frictionbps * ((float)plugin.cnf.delta / 1000.0f) * ((float)plugin.cnf.delta / 1000.0f);
        this.relmaxbps = car.cmodel.maxbps * ((float)plugin.cnf.delta / 1000.0f);
        this.relbackbps = -car.cmodel.backbps * ((float)plugin.cnf.delta / 1000.0f);
        float alpha = car.model.getRotation().toAngles()[1];
        this.fxr = (float)Math.cos(alpha);
        this.fzr = (float)Math.sin(alpha);
        this.fxr = (int)alpha / 180 % 2 == 0 ? -this.fxr : this.fxr;
        this.fzr = (int)alpha / 180 % 2 == 0 ? this.fzr : -this.fzr;
        float blocksperdelta = car.cmodel.accelbps * ((float)plugin.cnf.delta / 1000.0f);
        this.fuelc = blocksperdelta * car.cmodel.fuelconsumption;
        if (plugin.cnf.physics) {
            this.tphysics = new PhysicsThread(car, plugin, this);
        }
    }

    @Override
    public synchronized void run() {
        if (this.plugin.cnf.physics) {
            this.tphysics.start();
        }
        try {
            while (true) {
                float alpha;
                float speed = this.speedFactor / ((float)this.plugin.cnf.delta / 1000.0f);
                this.car.updateGUI(speed, this.rotationFactor / ((float)this.plugin.cnf.delta / 1000.0f));
                this.rotationFactor = 0.0f;
                Thread.sleep(this.plugin.cnf.delta);
                if (this.speedFactor >= this.speedFactorFriction) {
                    this.speedFactor -= this.speedFactorFriction;
                    this.fx = this.fxr * this.speedFactor;
                    this.fz = this.fzr * this.speedFactor;
                } else if (this.speedFactor < this.speedFactorFriction) {
                    if (this.speedFactor < 0.0f) {
                        this.speedFactor += this.speedFactorFriction;
                        this.fx = this.fxr * this.speedFactor;
                        this.fz = this.fzr * this.speedFactor;
                    } else {
                        this.speedFactor = 0.0f;
                        this.fz = 0.0f;
                        this.fx = 0.0f;
                    }
                }
                this.car.model.setPosition(this.car.model.getPosition().x + this.fx, this.car.model.getPosition().y, this.car.model.getPosition().z + this.fz);
                if (this.car.driver != null) {
                    float r = this.car.model.getRotation().toAngles()[1];
                    float driverx = this.car.model.getPosition().x - (float)((double)this.car.cmodel.driverx * Math.cos(r) - (double)this.car.cmodel.driverz * Math.sin(r));
                    float driverz = this.car.model.getPosition().z + (float)((double)this.car.cmodel.driverx * Math.sin(r) + (double)this.car.cmodel.driverz * Math.cos(r));
                    this.car.driver.setPosition(driverx, this.car.model.getPosition().y + this.car.cmodel.drivery, driverz);
                }
                if (this.plugin.cnf.textlive3d) {
                    this.car.textLive.setPosition(this.car.model.getPosition().x, this.car.model.getPosition().y + this.car.cmodel.livetexty, this.car.model.getPosition().z);
                }
                if (this.w) {
                    if (this.speedFactor < 0.0f) {
                        this.speedFactor += this.speedFactorBrake;
                        this.fx = this.fxr * this.speedFactor;
                        this.fz = this.fzr * this.speedFactor;
                    } else if (this.speedFactor <= this.relmaxbps && this.car.fuel > 0.0f) {
                        this.speedFactor += this.speedFactorAccel;
                        this.fx = this.fxr * this.speedFactor;
                        this.fz = this.fzr * this.speedFactor;
                        this.decreaseFuel();
                    }
                }
                if (this.s) {
                    if (this.speedFactor > 0.0f) {
                        this.speedFactor -= this.speedFactorBrake;
                        this.fx = this.fxr * this.speedFactor;
                        this.fz = this.fzr * this.speedFactor;
                    } else if (this.speedFactor >= this.relbackbps && this.car.fuel > 0.0f) {
                        this.speedFactor -= this.speedFactorAccel;
                        this.fx = this.fxr * this.speedFactor;
                        this.fz = this.fzr * this.speedFactor;
                        this.decreaseFuel();
                    }
                }
                if (this.a && this.speedFactor != 0.0f) {
                    this.rotationFactor = 360.0f / (this.car.cmodel.tc / this.speedFactor);
                    float[] f = this.car.model.getRotation().toAngles();
                    f[1] = f[1] + Utils.MathUtils.degreeToRadian((float)this.rotationFactor);
                    this.car.model.setRotation(new Quaternion().fromAngles(f));
                    if (this.car.driver != null) {
                        f = this.car.driver.getRotation().toAngles();
                        f[1] = f[1] + Utils.MathUtils.degreeToRadian((float)this.rotationFactor);
                        this.car.driver.setRotation(f[0], f[1], f[2]);
                    }
                    alpha = this.car.model.getRotation().toAngles()[1];
                    this.fxr = (float)Math.cos(alpha);
                    this.fzr = (float)Math.sin(alpha);
                    this.fxr = (int)alpha / 180 % 2 == 0 ? -this.fxr : this.fxr;
                    this.fzr = (int)alpha / 180 % 2 == 0 ? this.fzr : -this.fzr;
                    this.fx = this.fxr * this.speedFactor;
                    this.fz = this.fzr * this.speedFactor;
                }
                if (!this.d || this.speedFactor == 0.0f) continue;
                this.rotationFactor = 360.0f / (this.car.cmodel.tc / this.speedFactor);
                float[] f = this.car.model.getRotation().toAngles();
                f[1] = f[1] - Utils.MathUtils.degreeToRadian((float)this.rotationFactor);
                this.car.model.setRotation(new Quaternion().fromAngles(f));
                if (this.car.driver != null) {
                    f = this.car.driver.getRotation().toAngles();
                    f[1] = f[1] - Utils.MathUtils.degreeToRadian((float)this.rotationFactor);
                    this.car.driver.setRotation(f[0], f[1], f[2]);
                }
                alpha = this.car.model.getRotation().toAngles()[1];
                this.fxr = (float)Math.cos(alpha);
                this.fzr = (float)Math.sin(alpha);
                this.fxr = (int)alpha / 180 % 2 == 0 ? -this.fxr : this.fxr;
                this.fzr = (int)alpha / 180 % 2 == 0 ? this.fzr : -this.fzr;
                this.fx = this.fxr * this.speedFactor;
                this.fz = this.fzr * this.speedFactor;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.d = false;
            this.s = false;
            this.a = false;
            this.w = false;
            this.car.driver = null;
            this.tphysics.interrupt();
            return;
        }
    }

    private void decreaseFuel() {
        if (this.plugin.cnf.carfuel) {
            this.car.fuel -= this.fuelc;
            if (this.car.fuel < 0.0f) {
                this.car.fuel = 0.0f;
            }
            this.car.updateFuel();
        }
    }
}

