/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector2i;

public class GuiVerticalLayout
extends GuiLayout {
    private int maxVisibleRows = Integer.MAX_VALUE;
    private GuiImage buttonNext = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
    private GuiImage buttonPrev;
    private int firstItem = 0;
    private int numOfVisibleRows;
    private int visibleRowsHeight;
    private int visibleRowsSpacing;
    private int visibleRowsTop;
    private int visibleRowsWidth;

    public GuiVerticalLayout(int flags) {
        super(flags);
        RWGui.setImage(this.buttonNext, 0);
        this.buttonNext.setPivot(PivotPosition.BottomLeft);
        this.buttonNext.setClickable(true);
        this.buttonNext.setVisible(false);
        this.baseAddChild((GuiElement)this.buttonNext);
        this.buttonPrev = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage(this.buttonPrev, 3);
        this.buttonPrev.setPivot(PivotPosition.TopLeft);
        this.buttonPrev.setClickable(true);
        this.buttonPrev.setVisible(false);
        this.baseAddChild((GuiElement)this.buttonPrev);
    }

    public void setMaxVisibleRows(int newMaxVisibleRows) {
        if (newMaxVisibleRows < 1) {
            newMaxVisibleRows = Integer.MAX_VALUE;
        }
        this.maxVisibleRows = newMaxVisibleRows;
    }

    public int getMaxVisibleRows() {
        return this.maxVisibleRows;
    }

    @Override
    public Integer getItemId(GuiElement element) {
        RWGui.Pair<Integer, Object> myData = this.getItemData(element);
        return myData.getL();
    }

    @Override
    public RWGui.Pair<Integer, Object> getItemData(GuiElement element) {
        if (element == this.buttonPrev) {
            this.scrollUp();
            return new RWGui.Pair<Integer, Object>(-2, null);
        }
        if (element == this.buttonNext) {
            this.scrollDown();
            return new RWGui.Pair<Integer, Object>(-3, null);
        }
        return super.getItemData(element);
    }

    @Override
    public void addChild(GuiElement element, Integer id, Object data) {
        super.addChild(element, id, data);
        if (this.numOfVisibleRows < this.maxVisibleRows) {
            ++this.numOfVisibleRows;
        }
    }

    @Override
    public void removeChild(GuiElement element) {
        super.removeChild(element);
        if (this.numOfVisibleRows <= this.maxVisibleRows) {
            --this.numOfVisibleRows;
        }
    }

    public int removeChild(int itemIndex) {
        if (itemIndex < 0 || itemIndex >= this.children.size()) {
            return -1;
        }
        this.removeChild((GuiElement)((RWGui.Pair)this.children.get(itemIndex)).getL());
        return itemIndex;
    }

    @Override
    public void free() {
        this.baseRemoveChild((GuiElement)this.buttonNext);
        this.baseRemoveChild((GuiElement)this.buttonPrev);
        super.free();
    }

    @Override
    public void hide(Player player) {
        player.removeGuiElement((GuiElement)this.buttonNext);
        player.removeGuiElement((GuiElement)this.buttonPrev);
        super.hide(player);
    }

    @Override
    public void show(Player player) {
        player.addGuiElement((GuiElement)this.buttonNext);
        player.addGuiElement((GuiElement)this.buttonPrev);
        super.show(player);
    }

    @Override
    void layout(int minWidth, int minHeight, boolean reset) {
        int height;
        int width;
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        if (reset) {
            width = 0;
            minHeight = 0;
            height = 0;
            int count = 0;
            for (RWGui.Pair item : this.children) {
                GuiElement element = (GuiElement)item.getL();
                if (element instanceof GuiLayout) {
                    ((GuiLayout)element).layout(width, 0, reset);
                }
                Vector2i elemSizes = RWGui.getElementSizes(element);
                if (width < elemSizes.x) {
                    width = elemSizes.x;
                }
                if (count >= this.firstItem && count < this.firstItem + this.maxVisibleRows) {
                    height += elemSizes.y + this.padding;
                }
                ++count;
            }
            this.visibleRowsHeight = height -= this.padding;
            this.visibleRowsWidth = width;
            this.visibleRowsSpacing = this.padding;
            this.visibleRowsTop = height + this.margin;
            width += this.margin;
            height += this.margin * 2;
        } else {
            for (RWGui.Pair item : this.children) {
                GuiElement element = (GuiElement)item.getL();
                if (!(element instanceof GuiLayout)) continue;
                ((GuiLayout)element).layout(this.visibleRowsWidth, 0, reset);
            }
            width = this.visibleRowsWidth + this.margin;
            height = this.visibleRowsHeight + this.margin * 2;
            this.visibleRowsSpacing = this.padding;
            this.visibleRowsTop = height - this.margin;
            if (minHeight > height) {
                if ((this.flags & 0x10) != 0) {
                    this.visibleRowsTop -= minHeight - height;
                } else if ((this.flags & 8) != 0) {
                    this.visibleRowsTop -= (minHeight - height) / 2;
                } else if ((this.flags & 0x20) != 0) {
                    this.visibleRowsTop = minHeight - this.margin;
                    this.visibleRowsSpacing = this.padding + (minHeight - height) / (this.children.size() - 1);
                }
                height = minHeight;
            }
        }
        if (this.children.size() > this.maxVisibleRows) {
            this.buttonPrev.setPosition((float)(width += this.padding), (float)this.visibleRowsTop, false);
            this.buttonNext.setPosition((float)width, (float)this.margin, false);
            width += 18;
        }
        if ((width += this.margin) < minWidth) {
            width = minWidth;
        }
        this.setSize(width, height, false);
        this.updateChildren();
    }

    private void scrollDown() {
        this.firstItem += this.maxVisibleRows - 1;
        if (this.firstItem + this.maxVisibleRows > this.children.size()) {
            this.firstItem = this.children.size() - this.maxVisibleRows;
        }
        this.updateChildren();
    }

    private void scrollUp() {
        this.firstItem -= this.maxVisibleRows - 1;
        if (this.firstItem < 0) {
            this.firstItem = 0;
        }
        this.updateChildren();
    }

    private void updateChildren() {
        int count = 0;
        int y = this.visibleRowsTop;
        for (RWGui.Pair item : this.children) {
            GuiElement element = (GuiElement)item.getL();
            if (count < this.firstItem || count >= this.firstItem + this.maxVisibleRows) {
                element.setVisible(false);
            } else {
                boolean centred = (this.flags & 1) != 0;
                int height = RWGui.getElementSizes((GuiElement)element).y;
                int x = this.margin + (centred ? this.visibleRowsWidth / 2 : ((this.flags & 2) != 0 ? this.visibleRowsWidth : 0));
                int yDelta = centred ? -(height / 2) : 0;
                element.setPosition((float)x, (float)(y + yDelta), false);
                element.setVisible(true);
                y -= height + this.visibleRowsSpacing;
            }
            ++count;
        }
        this.buttonPrev.setVisible(this.firstItem > 0);
        this.buttonNext.setVisible(this.firstItem + this.maxVisibleRows < this.children.size());
    }
}

