/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiTitleBar;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class GuiModelessWindow
extends GuiPanel {
    private static final int PANEL_XPOS = 20;
    private static final int PANEL_YPOS = 70;
    private static final int PANEL_WIDTH = 300;
    private static final int PANEL_COLOUR = -522149664;
    private static final int BORDER_COLOUR = 255;
    private static final int TEXT_COLOUR = 255;
    private static final int TEXT_XPOS = 6;
    private static final int TEXT_YDELTA = 36;
    private Player player;
    private GuiLabel[] labels;
    private GuiTitleBar titleBar;

    public GuiModelessWindow(Plugin plugin, Player player, String titleText, List<String> texts) {
        this.player = player;
        this.setPivot(PivotPosition.TopLeft);
        this.setSize(300.0f, 0.0f, false);
        this.setBorderColor(255);
        this.setBorderThickness(2.0f, false);
        this.setColor(-522149664);
        this.setVisible(true);
        this.titleBar = new GuiTitleBar((GuiElement)this, titleText, false);
        this.titleBar.addToPlayer(player);
        player.addGuiElement((GuiElement)this);
        if (texts != null) {
            this.setTexts(texts);
        }
    }

    public void setTexts(List<String> texts) {
        int numOfTexts = texts.size();
        int panelHeight = 18 + 15 * texts.size() + 6 * (texts.size() + 3);
        int panelWidth = (int)(0.5f * (float)this.titleBar.getTitleText().length() * 18.0f);
        int i = 0;
        while (i < numOfTexts) {
            int textWidth = (int)(0.5f * (float)texts.get(i).length() * 15.0f);
            if (textWidth > panelWidth) {
                panelWidth = textWidth;
            }
            ++i;
        }
        this.setPosition(20.0f, 70 + panelHeight, false);
        this.setSize(panelWidth += 12, panelHeight, false);
        this.titleBar.relayout();
        this.releaseTexts();
        int yPos = panelHeight - 36;
        this.labels = new GuiLabel[numOfTexts];
        int i2 = 0;
        while (i2 < numOfTexts) {
            this.labels[i2] = new GuiLabel(texts.get(i2), 6.0f, (float)yPos, false);
            this.labels[i2].setPivot(PivotPosition.TopLeft);
            this.labels[i2].setFontColor(255);
            this.labels[i2].setFontSize(15);
            this.labels[i2].setClickable(false);
            this.addChild((GuiElement)this.labels[i2]);
            this.player.addGuiElement((GuiElement)this.labels[i2]);
            yPos -= 21;
            ++i2;
        }
    }

    public void free() {
        this.titleBar.removeFromPlayer(this.player);
        this.titleBar.free();
        this.titleBar = null;
        this.player.removeGuiElement((GuiElement)this);
        this.releaseTexts();
    }

    private void releaseTexts() {
        if (this.labels != null) {
            int numOfTexts = this.labels.length;
            int i = 0;
            while (i < numOfTexts) {
                this.player.removeGuiElement((GuiElement)this.labels[i]);
                this.removeChild((GuiElement)this.labels[i]);
                this.labels[i] = null;
                ++i;
            }
            this.labels = null;
        }
    }
}

