/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiHorizontalLayout;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiTitleBar;
import com.vistamaresoft.rwgui.GuiVerticalLayout;
import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class GuiModalWindow
extends GuiPanel
implements Listener {
    protected boolean autoClose;
    protected RWGui.RWGuiCallback callback;
    protected GuiLayout layout;
    protected int listenerRef;
    protected GuiModalWindow prevWindow;
    protected Plugin plugin;
    protected GuiTitleBar titleBar;

    public GuiModalWindow(Plugin plugin, String title, int layoutType, RWGui.RWGuiCallback callback) {
        this.setPosition(0.5f, 0.5f, true);
        this.setPivot(PivotPosition.Center);
        this.setBorderColor(-1869573889);
        this.setBorderThickness(2.0f, false);
        this.setColor(0x202020FF);
        this.autoClose = false;
        this.callback = callback;
        this.plugin = plugin;
        this.layout = layoutType == 1 ? new GuiHorizontalLayout(0) : new GuiVerticalLayout(0);
        this.layout.setMargin(6);
        this.layout.setPivot(PivotPosition.BottomLeft);
        this.layout.setPosition(0.0f, 0.0f, false);
        super.addChild((GuiElement)this.layout);
        this.titleBar = new GuiTitleBar(null, title, true);
        super.addChild((GuiElement)this.titleBar);
        this.listenerRef = 0;
    }

    @EventMethod
    public void onClick(PlayerGuiElementClickEvent event) {
        if (this.callback == null) {
            return;
        }
        GuiElement element = event.getGuiElement();
        Player player = event.getPlayer();
        if (this.titleBar.isCancelButton(element)) {
            this.pop(player);
            this.callback.onCall(player, -1, null);
            return;
        }
        RWGui.Pair<Integer, Object> data = this.layout.getItemData(element);
        if (data != null) {
            int id = data.getL();
            if (id == -1 || id == 0 || id >= -1 && this.autoClose) {
                this.pop(player);
            }
            if (id >= -1) {
                this.callback.onCall(player, id, element instanceof GuiTextField ? null : data.getR());
            }
        }
    }

    @EventMethod
    public void onTextEntry(PlayerGuiInputEvent event) {
        if (this.callback == null) {
            return;
        }
        Integer id = this.layout.getItemId(event.getGuiElement());
        if (id != null) {
            this.callback.onCall(event.getPlayer(), id, event.getInput());
        }
    }

    public void setCallback(RWGui.RWGuiCallback callback) {
        this.callback = callback;
    }

    public void setMargin(int value) {
        this.layout.setMargin(value);
    }

    public void setPadding(int value) {
        this.layout.setPadding(value);
    }

    public void layout() {
        int tbw = this.titleBar.getMinWidth();
        this.layout.layout(tbw, 0);
        int height = (int)this.layout.getHeight();
        int width = (int)this.layout.getWidth();
        int borderW = (int)this.getBorderThickness();
        this.layout.setPosition(borderW, borderW, false);
        this.layout.setSize(width - borderW * 2, height - borderW, false);
        this.setSize(width, height += (int)this.titleBar.getHeight(), false);
        this.titleBar.relayout();
    }

    public void addChild(GuiElement element) {
        this.layout.addChild(element);
    }

    public void addChild(GuiElement element, Integer id, Object data) {
        this.layout.addChild(element, id, data);
    }

    public void removeChild(GuiElement element) {
        this.layout.removeChild(element);
    }

    public void show(Player player) {
        this.layout();
        this.titleBar.addToPlayer(player);
        this.layout.show(player);
        ++this.listenerRef;
        if (this.listenerRef == 1) {
            this.plugin.registerEventListener((Listener)this);
        }
        player.addGuiElement((GuiElement)this);
        player.setMouseCursorVisible(true);
    }

    public void close(Player player) {
        this.titleBar.removeFromPlayer(player);
        this.layout.hide(player);
        player.removeGuiElement((GuiElement)this);
        --this.listenerRef;
        if (this.listenerRef <= 0) {
            this.plugin.unregisterEventListener((Listener)this);
        }
        player.setMouseCursorVisible(false);
    }

    public void push(Player player, GuiModalWindow win) {
        this.close(player);
        win.prevWindow = this;
        win.show(player);
    }

    public void pop(Player player) {
        this.close(player);
        this.free();
        if (this.prevWindow != null) {
            this.prevWindow.show(player);
            player.setMouseCursorVisible(true);
        } else {
            player.setMouseCursorVisible(false);
        }
    }

    public void poppush(Player player, GuiModalWindow win) {
        this.close(player);
        this.free();
        if (this.prevWindow != null) {
            this.prevWindow.prevWindow = win;
        }
        win.show(player);
        player.setMouseCursorVisible(true);
    }

    public Integer getItemId(GuiElement element) {
        return this.layout.getItemId(element);
    }

    public void free() {
        if (this.titleBar != null) {
            this.titleBar.free();
            this.titleBar = null;
        }
        if (this.layout != null) {
            this.layout.free();
            this.layout = null;
        }
    }
}

