/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import java.util.ArrayList;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.utils.Vector2i;

public class GuiTableLayout
extends GuiLayout {
    private int maxNumOfCols;
    private int maxNumOfRows;
    private int[] colFlags;
    private int[] rowFlags;

    public GuiTableLayout(int maxNumOfCols, int maxNumOfRows, int flags) {
        super(flags);
        this.maxNumOfCols = maxNumOfCols;
        this.maxNumOfRows = maxNumOfRows;
        this.colFlags = new int[maxNumOfCols];
        int i = 0;
        while (i < maxNumOfCols) {
            this.colFlags[i] = 0;
            ++i;
        }
        this.rowFlags = new int[maxNumOfRows];
        i = 0;
        while (i < maxNumOfRows) {
            this.rowFlags[i] = 8;
            ++i;
        }
    }

    public void setColFlag(int idx, int flag) {
        if (idx >= 0 && idx < this.maxNumOfCols) {
            this.colFlags[idx] = flag;
            if ((flag & 2) != 0 && this.children != null) {
                int i = idx;
                while (i < this.children.size()) {
                    if (this.children.get(i) != null) {
                        ((GuiElement)((RWGui.Pair)this.children.get(i)).getL()).setPivot(PivotPosition.TopRight);
                    }
                    i += this.maxNumOfCols;
                }
            }
        }
    }

    public void setRowFlag(int idx, int flag) {
        if (idx >= 0 && idx < this.maxNumOfRows) {
            this.rowFlags[idx] = flag;
        }
    }

    @Override
    public void addChild(GuiElement element, Integer id, Object data) {
        if (this.children == null) {
            this.children = new ArrayList(this.maxNumOfCols * this.maxNumOfRows);
        }
        if (this.children.size() < this.maxNumOfCols * this.maxNumOfRows) {
            if (element == null) {
                this.children.add(null);
            } else {
                int col = this.children.size() % this.maxNumOfCols;
                super.addChild(element, id, data);
                if ((this.colFlags[col] & 2) != 0) {
                    element.setPivot(PivotPosition.TopRight);
                }
            }
        }
    }

    @Override
    void layout(int minWidth, int minHeight, boolean reset) {
        int row;
        int col;
        int count;
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        Vector2i[] elemSizes = new Vector2i[this.maxNumOfCols * this.maxNumOfRows];
        int[] colWidths = new int[this.maxNumOfCols];
        int[] rowHeights = new int[this.maxNumOfRows];
        int height = 0;
        int width = 0;
        if (reset) {
            height = 0;
            minHeight = 0;
            width = 0;
            minWidth = 0;
        } else {
            count = 0;
            for (RWGui.Pair item : this.children) {
                if (item != null) {
                    elemSizes[count] = RWGui.getElementSizes((GuiElement)item.getL());
                    col = count % this.maxNumOfCols;
                    row = count / this.maxNumOfCols;
                    if (colWidths[col] < elemSizes[count].x) {
                        colWidths[col] = elemSizes[count].x;
                    }
                    if (rowHeights[row] < elemSizes[count].y) {
                        rowHeights[row] = elemSizes[count].y;
                    }
                }
                if (++count >= this.maxNumOfCols * this.maxNumOfRows) break;
            }
            ++count;
        }
        count = 0;
        for (RWGui.Pair item : this.children) {
            if (item != null) {
                GuiElement element = (GuiElement)item.getL();
                col = count % this.maxNumOfCols;
                row = count / this.maxNumOfCols;
                if (element instanceof GuiLayout) {
                    ((GuiLayout)element).layout(colWidths[col], rowHeights[row], reset);
                }
                elemSizes[count] = RWGui.getElementSizes(element);
                if (colWidths[col] < elemSizes[count].x) {
                    colWidths[col] = elemSizes[count].x;
                }
                if (rowHeights[row] < elemSizes[count].y) {
                    rowHeights[row] = elemSizes[count].y;
                }
            }
            if (++count >= this.maxNumOfCols * this.maxNumOfRows) break;
        }
        int i = 0;
        while (i < this.maxNumOfCols) {
            width += colWidths[i] + this.padding;
            ++i;
        }
        width += this.margin * 2 - this.padding;
        i = 0;
        while (i < this.maxNumOfRows) {
            height += rowHeights[i] + this.padding;
            ++i;
        }
        int spacingH = this.padding;
        int spacingW = this.padding;
        count = 0;
        int x = this.margin;
        int y = (height += this.margin * 2 - this.padding) - this.margin;
        for (RWGui.Pair item : this.children) {
            col = count % this.maxNumOfCols;
            row = count / this.maxNumOfCols;
            if (item != null) {
                int elX;
                Vector2i elementSizes = elemSizes[count];
                int n = (this.colFlags[col] & 2) != 0 ? colWidths[col] : (elX = (this.colFlags[col] & 1) != 0 ? (colWidths[col] - elementSizes.x) / 2 : 0);
                int elY = (this.rowFlags[row] & 0x10) != 0 ? -(rowHeights[row] - elementSizes.y) : ((this.colFlags[col] & 8) != 0 ? (elementSizes.y - rowHeights[row]) / 2 : 0);
                ((GuiElement)item.getL()).setPosition((float)(x + elX), (float)(y + elY), false);
            }
            x += colWidths[col] + spacingW;
            if (col == this.maxNumOfCols - 1) {
                x = 0;
                y -= rowHeights[row] + spacingH;
            }
            if (++count >= this.maxNumOfCols * this.maxNumOfRows) break;
        }
        this.setSize(width, height, false);
    }
}

