/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.pnb;

import com.vistamaresoft.pnb.Gui;
import com.vistamaresoft.pnb.Msgs;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class PlanksAndBeams
extends Plugin
implements Listener {
    public static final String localeLanguageDef = "en";
    public static String commandPrefix = "/pnb";
    public static int costPerItem = 1;
    public static Locale locale;
    public static final String VERSION = "0.2.0";
    public static final String publicName = "Planks 'n Beams";
    public static final int NUM_OF_QUICKSLOTS = 5;
    public static final int NUM_OF_INVSLOTS = 32;
    public static final short ORE_ID = 100;
    public static final short LUMBER_ID = 102;
    public static final short PLANK_ID = 113;
    public static final short BEAM_ID = 114;
    public static final short PLANKTRI_ID = 124;
    public static final short IRONINGOT_ID = 171;
    public static final short COPPERINGOT_ID = 172;
    public static final short DIRT_VAR = 1;
    public static final short STONE_VAR = 3;
    public static final short SANDSTONE_VAR = 11;
    protected static final Inventory.SlotType[] slotTypeValues;
    public static final short[] resourceId;
    public static final short[] resourceVar;
    public static final short firstVariation = 21;
    public static final short lastVariation = 212;
    public static final short[] resourcePerVariation;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_PARAM = -1;
    public static final int ERR_NO_RESOURCES = -2;
    public static final int ERR_GENERIC = -3;
    protected static PlanksAndBeams plugin;
    protected static String pluginPath;

    static {
        slotTypeValues = Inventory.SlotType.values();
        resourceId = new short[]{100, 100, 100, 102, 172, 171};
        short[] sArray = new short[6];
        sArray[0] = 3;
        sArray[1] = 11;
        sArray[2] = 1;
        resourceVar = sArray;
        short[] sArray2 = new short[192];
        sArray2[12] = 1;
        sArray2[13] = 1;
        sArray2[14] = 1;
        sArray2[15] = 1;
        sArray2[28] = 2;
        sArray2[29] = 2;
        sArray2[30] = 2;
        sArray2[31] = 2;
        sArray2[40] = 3;
        sArray2[41] = 3;
        sArray2[42] = 3;
        sArray2[43] = 3;
        sArray2[44] = 3;
        sArray2[45] = 3;
        sArray2[46] = 3;
        sArray2[47] = 3;
        sArray2[48] = 3;
        sArray2[49] = 3;
        sArray2[50] = 3;
        sArray2[51] = 3;
        sArray2[52] = 3;
        sArray2[53] = 3;
        sArray2[54] = 3;
        sArray2[55] = 3;
        sArray2[56] = 3;
        sArray2[57] = 3;
        sArray2[58] = 3;
        sArray2[59] = 3;
        sArray2[64] = 3;
        sArray2[65] = 3;
        sArray2[66] = 3;
        sArray2[67] = 3;
        sArray2[68] = 3;
        sArray2[69] = 3;
        sArray2[70] = 3;
        sArray2[71] = 3;
        sArray2[72] = 3;
        sArray2[73] = 3;
        sArray2[74] = 3;
        sArray2[75] = 3;
        sArray2[76] = 3;
        sArray2[77] = 3;
        sArray2[78] = 3;
        sArray2[79] = 3;
        sArray2[150] = 4;
        sArray2[151] = 4;
        sArray2[152] = 4;
        sArray2[153] = 4;
        sArray2[154] = 5;
        sArray2[155] = 5;
        sArray2[156] = 5;
        sArray2[157] = 5;
        sArray2[158] = 5;
        sArray2[159] = 5;
        sArray2[160] = 5;
        sArray2[161] = 5;
        sArray2[162] = 5;
        sArray2[163] = 5;
        sArray2[164] = 5;
        sArray2[165] = 5;
        sArray2[166] = 5;
        sArray2[167] = 5;
        sArray2[168] = 5;
        sArray2[169] = 5;
        sArray2[170] = 5;
        sArray2[171] = 5;
        sArray2[172] = 5;
        sArray2[173] = 5;
        sArray2[174] = 5;
        sArray2[175] = 5;
        sArray2[176] = 5;
        sArray2[177] = 5;
        resourcePerVariation = sArray2;
    }

    public void onEnable() {
        plugin = this;
        pluginPath = this.getPath();
        this.initSettings();
        Msgs.init(pluginPath, locale);
        System.out.println("Planks 'n Beams 0.2.0 loaded successfully!");
        this.registerEventListener(this);
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        System.out.println("Planks 'n Beams 0.2.0 unloaded successfully!");
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.mainGui(event.getPlayer());
        }
    }

    public String getPublicName() {
        return publicName;
    }

    public void mainGui(Player player) {
        Gui gui = new Gui(player);
        if (gui != null) {
            gui.show(player);
        }
    }

    public int buy(Player player, int type, int variation, int quantity) {
        Item item;
        if (variation < 21 || variation > 212) {
            return -1;
        }
        short itemId = resourceId[resourcePerVariation[variation - 21]];
        short itemVar = resourceVar[resourcePerVariation[variation - 21]];
        Inventory inv = player.getInventory();
        int cost = quantity * costPerItem;
        int resources = 0;
        ArrayList<Integer> sourceSlots = new ArrayList<Integer>();
        int invType = 0;
        while (invType < slotTypeValues.length) {
            Inventory.SlotType slotType = slotTypeValues[invType];
            int j = 0;
            while (j < inv.getSlotCount(slotType)) {
                item = inv.getItem(j, slotType);
                if (item != null && item.getTypeID() == itemId && item.getVariation() == itemVar) {
                    resources += item.getStacksize();
                    sourceSlots.add((invType << 16) + j);
                }
                ++j;
            }
            ++invType;
        }
        if (resources < cost) {
            return -2;
        }
        item = inv.insertNewItem((short)type, variation, quantity);
        if (item == null) {
            return -3;
        }
        for (Integer i : sourceSlots) {
            item = inv.getItem(i & 0xFFFF, slotTypeValues[i >> 16]);
            int size = item.getStacksize();
            if (size <= cost) {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16]);
                cost -= size;
            } else {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16], cost);
                cost = 0;
            }
            if (cost <= 0) break;
        }
        return 0;
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            Integer temp = PlanksAndBeams.toInteger(settings.getProperty("costPerItem", Integer.toString(costPerItem)));
            costPerItem = temp != null ? temp : costPerItem;
            String strLocale = settings.getProperty("locale", localeLanguageDef);
            String[] localeParams = strLocale.split("-");
            locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
        }
        catch (IOException e) {
            locale = new Locale(localeLanguageDef);
            return;
        }
    }

    protected static Integer toInteger(String txt) {
        int val;
        if (txt == null) {
            return null;
        }
        try {
            val = Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return val;
    }
}

