////////////////////////////////////////////////////////////////////////////////////
/////    Weather Shader for weather effects like rain or snow                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Pointlighting.glsllib"

#ifdef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraDirection;
uniform vec3 g_CameraPosition;
uniform float g_Time;

uniform vec4 m_Sunlight;
uniform vec4 m_Ambient;

uniform float m_TextureScale;

uniform vec4 m_WeatherInfo;  //LayerA, LayerB, FadeA, FadeB

uniform vec2 m_Direction;

attribute vec3 inPosition;
attribute vec3 inNormal;
attribute vec4 inColor;
attribute vec2 inTexCoord;

varying vec3 position;
varying vec4 rainCoord;
varying vec4 snowCoord;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 invcamdir;
varying vec3 light;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

vec3 getSunlightColor(){
    return vec3(smoothstep(0.0, 0.6, m_Sunlight.w) * 0.9 + 0.1);
}

void calculateStaticlight(in vec3 normal, in vec4 staticlight, out vec3 light){
    //StaticLights
    light = (staticlight.rgb * (1.0 - (m_Sunlight.w * staticlight.a) + 0.25)) + vec3(staticlight.w * 0.5 + (staticlight.w * 0.65 * max(dot(m_Sunlight.xyz, normal) * -1.0 * m_Sunlight.w, 0.0)) + (m_Ambient.rgb * m_Ambient.a)) * getSunlightColor();
}

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    pos.x += (15.0 - step(1.0, inPosition.y) * 30.0);
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    invcamdir = g_CameraDirection * -1.0;
    normal = m_Sunlight.xyz * -1.0;
    
    //float nx = step(0.5, abs(inNormal.x));
    //float nz = step(0.5, abs(inNormal.z));
    //vec3 coords = inTexCoord.xyx;//vec3(mix(inPosition.x, worldpos.x, 0.05), mix(inPosition.y, worldpos.y, 0.5), mix(inPosition.z, worldpos.z, 0.05));
    //float ccx = coords.z * nx + coords.x * nz;
    
    //vec2 animcoord = vec2(ccx * 3.0, coords.y * 0.1) * 0.1;
    //vec2(inTexCoord.x, coords.y) * 0.02 + vec2(sin(ccx), -g_Time * m_Direction.y);    //0.5
    
    float fall = g_Time * m_Direction.y;
    rainCoord = vec4(inTexCoord.x * 5.0, mix(inPosition.y * 0.2, worldpos.y * 0.2, 0.75) * 0.2 - fall + max(inPosition.x, inPosition.z), (m_WeatherInfo.x + 0.5) / 4.0, m_WeatherInfo.z);
    snowCoord = vec4(inTexCoord.x * 2.0, mix(inPosition.y * 0.2, worldpos.y * 0.2, 0.25) - fall, (m_WeatherInfo.y + 0.5) / 4.0, m_WeatherInfo.w);
    
    //Fade out if over clouds
    fade = 1.0 - smoothstep(400.0, 500.0, worldpos.y);
    
    //Staticlight calculation
    vec4 c = vec4(0.0, 0.0, 0.0, 110.0);//inColor;
    vec4 color = vec4(c.r * 0.01, c.g * 0.01, c.b * 0.01, c.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    calculateStaticlight(normal, color, light);
    
    //Optional: Per-Vertex-Lighting calculation (dynamic Spotlights)
    #ifdef VERTEXLIGHTING
        light = calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #endif
    light = max(light, vec3(0.35));
    
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif

}