////////////////////////////////////////////////////////////////////////////////////
/////    FlattenTool Shader for the flatten-tool-grid                          /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec4 m_Color;
uniform vec4 m_LineColor;
uniform float m_Linethickness;
uniform float m_Gridsize;

varying vec3 position;
varying vec2 texCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef COLOR
        vec4 fragColor = m_Color;
    #else
        vec4 fragColor = vec4(1.0);
    #endif

    #ifdef LINECOLOR
        float posx = mod(position.x + (m_Gridsize * 0.5), m_Gridsize);
        float posz = mod(position.z + (m_Gridsize * 0.5), m_Gridsize);
        if(posx > m_Linethickness && posx < (m_Gridsize-m_Linethickness) && posz > m_Linethickness && posz < (m_Gridsize-m_Linethickness)){
            fragColor = m_LineColor;
        }
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif  
}