////////////////////////////////////////////////////////////////////////////////////
/////    Sky Shader for daytime-dependent sky                                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_NightTexture;
uniform sampler2D m_NightFlareTexture;
uniform sampler2D m_MoonTexture;
uniform sampler2D m_CloudTexture;
uniform sampler2D m_CloudTexture2;
uniform vec4 m_CloudColor;
uniform vec3 m_Cloudiness;
uniform vec3 m_SunPosition;
uniform float m_DayNightTime;  //Range 0 - 1
uniform float m_BorderLevel;  //Range -1 - 200

varying vec3 position;
varying vec2 texCoord;
varying vec2 cloudCoord;
varying vec2 cloudCoord2;
varying vec4 fog;
varying float flicker;
varying float cloudalpha;

const vec3 sunColor = vec3(1.0, 1.0, 0.95);
const vec3 cloudNightColor = vec3(0.02,0.04,0.08);

void main(){
    vec3 daysky = vec3(0.6, 0.698, 0.949);
    //vec3 daysky = vec3(0.2, 0.3, 0.5);
    
    //#ifndef MOON
        #ifdef NIGHTTEXTURE
            //float starintensity = texture2D(m_NightTexture, texCoord * 5.0).r;
            //vec3 nightsky = mix(vec3(0.0), vec3(1.0), step(0.9, starintensity));
            vec4 nightsky = texture2D(m_NightTexture, texCoord * 5.0);
            nightsky.rgb *= flicker;
        #else
            vec3 nightsky = vec3(0.0, 0.0, 0.0);
            //vec4 nightsky = vec3(0.0, 0.0, 0.0, 1.0);
        #endif
        
        //Blend between day- and nightsky
        vec4 fragColor = vec4(1.0);
        fragColor.rgb = mix(nightsky.rgb, daysky.rgb, m_DayNightTime);

        vec3 finalSunColor = sunColor;
        #ifdef FOG
            fragColor.rgb = mix(fragColor.rgb, fog.rgb, 1.0 - smoothstep(0.0, 60.0, position.y));
            finalSunColor = mix(sunColor, fog.rgb, 0.15);
        #endif

        //Moon
        vec4 moon = texture2D(m_MoonTexture, texCoord * 10.0);
        fragColor.rgb = mix(fragColor.rgb, moon.rgb, moon.a);

        //Sun
        float distToSun = distance(position.xyz, m_SunPosition.xyz) + (7.0 * (1.0 - smoothstep(-11.0, 0.0, m_SunPosition.y)));
        fragColor.rgb = mix(finalSunColor, fragColor.rgb, max(smoothstep(-10.0, 50.0, distToSun) - (1.0 - step(3.5, distToSun)), 0.0));
    //#else
    //    vec4 fragColor = texture2D(m_MoonTexture, texCoord);
    //    fragColor.a *= smoothstep(0.0, 10.0, position.y);
    //#endif
    
    #ifdef CLOUDTEXTURE
        float fadefactor = smoothstep(0.0, 60.0, position.y) * (cloudalpha * m_CloudColor.a);
        float cloud1 = texture2D(m_CloudTexture, cloudCoord).r * fadefactor;
        float cloud2 = texture2D(m_CloudTexture, cloudCoord2).r * fadefactor;
        vec3 cloudColor = mix(cloudNightColor.rgb, m_CloudColor.rgb, m_DayNightTime);
        fragColor.rgb = mix(fragColor.rgb, cloudColor.rgb, cloud1);
        fragColor.rgb = mix(fragColor.rgb, cloudColor.rgb, cloud2);
        //fragColor.rgb = mix(fragColor.rgb, cloudColor.rgb, min(cloud1*2.0, 1.0));
        //fragColor.rgb = mix(fragColor.rgb, cloudColor.rgb, min(cloud2*2.0, 1.0));
    #endif
    
    #ifdef FOG
        //Fog Border
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, smoothstep(m_BorderLevel-4.0, m_BorderLevel+4.0, position.y));
    #else
        //Black Color
        fragColor.rgb *= smoothstep(m_BorderLevel-4.0, m_BorderLevel+4.0, position.y);
    #endif

    gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);  
}