////////////////////////////////////////////////////////////////////////////////////
/////    Sky Horizont Shader for far horizont mountains                        /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_HorizontTexture;
uniform float m_DayNightTime;  //Range 0 - 1
uniform float m_BorderLevel;  //Range -1 - 200

varying vec3 position;
varying vec2 texCoord;
varying vec4 fog;

const vec3 sunColor = vec3(1.0, 1.0, 0.95);
const vec3 cloudNightColor = vec3(0.02,0.04,0.08);

void main(){
    vec3 daysky = vec3(0.6, 0.698, 0.949);
    vec3 nightsky = vec3(0.0, 0.0, 0.0);
    
    //Blend between day- and nightsky
    vec2 newTexCoord = vec2(texCoord.x * 4.0, texCoord.y);
    vec4 fragColor = texture2D(m_HorizontTexture, newTexCoord);

    //Alpha discarding
    if(fragColor.a <= 0.1){
        discard;
    }

    fragColor.rgb = mix(nightsky.rgb, fragColor.rgb, m_DayNightTime);
    
    #ifdef FOG
        fragColor.rgb = mix(fragColor.rgb, fog.rgb, 1.0 - smoothstep(0.0, 60.0, position.y));
    #endif
    
    #ifdef FOG
        //Fog Border
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, smoothstep(m_BorderLevel-4.0, m_BorderLevel+4.0, position.y));
    #else
        //Black Color
        fragColor.rgb *= smoothstep(m_BorderLevel-4.0, m_BorderLevel+4.0, position.y);
    #endif

    gl_FragColor = fragColor;  
}