////////////////////////////////////////////////////////////////////////////////////
/////    PreShadow Shader for determing pre-shadow calculation                 /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;

attribute vec3 inPosition;
attribute vec4 inColor;

varying float intensity;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    intensity = step(0.6, inColor.w);
}