////////////////////////////////////////////////////////////////////////////////////
/////    Pre Refraction Shader to calculate refraction                         /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef NORMALMAPARRAY
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable

    uniform sampler2DArray m_NormalMaps_Array;
    varying vec3 texCoord;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef NORMALMAPARRAY
        vec4 fragColor = texture2DArray(m_NormalMaps_Array, texCoord);
        fragColor.a = 1.0;
    #else
        vec4 fragColor = vec4(0.0);
    #endif
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}