////////////////////////////////////////////////////////////////////////////////////
/////    NoRefraction Shader                                                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef MASKTEXTURES
    #extension GL_EXT_gpu_shader4 : enable
    #extension GL_EXT_texture_array : enable
    
    uniform sampler2DArray m_MaskTextures_Array;
    varying vec3 texCoord;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef MASKTEXTURES
        float alpha = texture2DArray(m_MaskTextures_Array, texCoord).r;
        alpha = step(0.5, alpha);
        gl_FragColor = vec4(0.0, 0.0, 0.0, alpha);
    #else
        gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
    #endif

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}