////////////////////////////////////////////////////////////////////////////////////
/////    RefractionFilter Shader (Post Processing)                             /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_Texture;
uniform sampler2D m_NormalTexture;

varying vec2 texCoord;

void main(){
    vec4 fragColor;

    #ifdef DEBUG
        fragColor = texture2D(m_NormalTexture, texCoord);
    #else
        //Get normal texture from pre pass
        vec4 normal = texture2D(m_NormalTexture, texCoord);

        //If normal value != black, do refractions
        if(normal.b > 0.0){
            //Calculate new texture coordinates depending on normal
            vec2 newTexCoord = texCoord;
            newTexCoord.xy += ((normal.xy * 2.0 - 1.0) * 0.05);
            newTexCoord = clamp(newTexCoord, 0.001, 0.999);

            //Check if inside refractive area (to avoid refraction leaking)
            float mask = texture2D(m_NormalTexture, newTexCoord).b;
            if(mask >= 0.01){
                fragColor = texture2D(m_Texture, newTexCoord);
            }
            else{
                fragColor = texture2D(m_Texture, texCoord);
            }
        }
        else{
            //Otherwise use regular scene texture
            fragColor = texture2D(m_Texture, texCoord);
        }
    #endif

    gl_FragColor = fragColor;

}
