////////////////////////////////////////////////////////////////////////////////////
/////    PixelationFilter Shader (Post Processing)                             /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_Texture;
uniform vec2 m_Pixelation;
uniform vec2 m_Resolution;
varying vec2 texCoord;

void main(){
    float valx = m_Pixelation.x * (1.0 / m_Resolution.x);
    float valy = m_Pixelation.y * (1.0 / m_Resolution.y);
    vec2 newTexCoord = vec2(valx * floor(texCoord.x / valx), valy * floor(texCoord.y / valy));
    vec4 fragColor = texture2D(m_Texture, newTexCoord);
    gl_FragColor = fragColor; 
}
