 ////////////////////////////////////////////////////////////////////////////////////
/////    Grass-Material Shader for Mesh-based Grass influenced by wind         /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_gpu_shader4 : enable
#extension GL_EXT_texture_array : enable

#import "Shaders/Lib/Selector.glsllib"

#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

#ifdef OCCLUSION
    #import "Shaders/Lib/Grassocclusion.glsllib"
#endif

uniform vec3 g_CameraDirection;

uniform sampler2DArray m_Textures_Array;
uniform float m_AlphaDiscardThreshold;

varying vec4 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec3 texCoord;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    #ifdef OCCLUSION
        vec2 occTexCoord = getOccludeTexCoord(worldpos);
        if(occTexCoord.x > 0.0 && occTexCoord.x < 1.0 && occTexCoord.y > 0.0 && occTexCoord.y < 1.0){
            float depth = texture2D(m_OccludeDepthTexture, occTexCoord).r;
            
            #ifdef LOGARITHMIC_DEPTH_BUFFER
                //depth = convertLogDepthBufferToZ(depth, 1.0, 1000.0);
            #endif
            
            float occludePosition = getOcclusionPosition(depth, occTexCoord).y;
            if(worldpos.y > occludePosition){
                discard;
            }
        }
    #endif
    
    #ifdef TEXTURES
        vec4 fragColor = texture2DArray(m_Textures_Array, texCoord);
        if(fragColor.a < m_AlphaDiscardThreshold){
            discard;
        }
        fragColor.a = 1.0;
    #else
        vec4 fragColor = vec4(1.0);
    #endif
    
    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= light;
    #endif
    
    #ifdef FOG
        fragColor.rgb = mix(fog.rgb, fragColor.rgb, fog.w);
    #endif
    
    #ifdef SELECTOR
        calculateSelector(worldpos, fragColor);
    #endif
    
    //Adjust brightness to fit better to the default grasstexture
    //fragColor.rgb *= 1.065;
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}