////////////////////////////////////////////////////////////////////////////////////
/////    ParticleSprite Shader for a fake particle-effect                      /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform float g_Time;

uniform float m_Speed;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec2 texCoord;
varying vec2 animationCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    vec2 anim = vec2(inTexCoord);
    float speed = g_Time * m_Speed;
    
    anim.y -= mod(speed, 1.0);
    
    animationCoord = anim;
    texCoord = inTexCoord;
}