////////////////////////////////////////////////////////////////////////////////////
/////    Vegetation-Material Shader for foliage (trees etc) influenced by wind /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#extension GL_EXT_draw_instanced : enable
#extension GL_EXT_gpu_shader4 : enable

#import "Shaders/Lib/Instancing.glsllib"
#import "Shaders/Lib/Staticlighting.glsllib"
#import "Shaders/Lib/Pointlighting.glsllib"
#ifdef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif
#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

#ifndef INSTANCING
    uniform mat4 g_WorldMatrix;
    uniform mat4 g_WorldViewMatrix;
    uniform mat4 g_WorldViewProjectionMatrix;
#endif
uniform mat3 g_WorldMatrixInverseTranspose;
uniform vec3 g_CameraDirection;

#ifdef WIND
    uniform float g_Time;
    #import "Shaders/Lib/Wind.glsllib"
#endif

attribute vec3 inPosition;
attribute vec3 inNormal;
attribute vec4 inColor;
attribute vec4 inTexCoord;    //X=TexCoordx, Y=TexCoordy, Z=TextureLayer, W=0(Bark) 1(Leaves) 2(Fruits) 3(Plants)
attribute vec2 inTexCoord2;   //Snowiness
#ifndef INSTANCING
    attribute vec3 inBinormal;
#endif

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec4 texCoord;
varying vec2 texCoord2;
varying vec4 fog;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    
    #ifdef INSTANCING
        vec4 world = transformWorld(pos);
        worldpos = world.xyz;
        vec4 viewpos = transformWorldViewFromWorld(world);
        position = inPosition;
        normal = normalize(transformNormal(normalize(inNormal)));
        texCoord = inTexCoord;
    #else
        vec4 viewpos = g_WorldViewMatrix * pos;
        position = inPosition;
        worldpos = vec3(g_WorldMatrix * pos);
        normal = normalize(g_WorldMatrixInverseTranspose * inNormal);
        texCoord = inTexCoord;
    #endif
    
    fade = smoothstep(0.0, 50.0, length(viewpos.xyz));
    texCoord2 = vec2(inTexCoord2);
    #ifdef FOG
        calculateFog(viewpos, fog);
    #endif
    
    //Windeffect
    #ifdef WIND
        #ifdef INSTANCING
            pos.xz += getInstancedVegetationWind(position);
        #else
            pos.xz += getVegetationWind(position, inBinormal);
        #endif
    #endif

    //Leafposition sundot calculation
    float sundot = 0.0;
    vec4 color = vec4(inColor.r * 0.01, inColor.g * 0.01, inColor.b * 0.01, inColor.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    if(inTexCoord.w < 0.5){
        sundot = dot(m_Sunlight.xyz, normal);
    }
    else if(inTexCoord.w >= 0.5){
        #ifndef DEFAULTSUNDOT
            #if defined(INSTANCING) || defined(CHOPPEDTREE)
                vec3 bi = normalize(position.xyz);
            #else
                vec3 bi = normalize(worldpos.xyz-inBinormal.xyz);
            #endif
            sundot = mix(dot(m_Sunlight.xyz, bi), dot(m_Sunlight.xyz, normal), 0.5);
        #endif
    }
    
    //Staticlight calculation
    calculateStaticlightBySundot(sundot, color, light);
    
    //Per-Vertex-Lighting calculation (dynamic Pointlights)
    light = calculatePointlights(light, worldpos, normal, g_CameraDirection, shininess);
    
    //Optional: Per-Vertex-Lighting calculation (dynamic Spotlights)
    #ifdef VERTEXLIGHTING
        light = calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #endif
    
    //Fogcolor calculation
    //fog.xyz *= (max(color.r, color.w) * m_Sunlight.w);
    
    #ifdef INSTANCING
        gl_Position = transformWorldViewProjection(pos);
    #else
        gl_Position = g_WorldViewProjectionMatrix * pos;
    #endif

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif

}