////////////////////////////////////////////////////////////////////////////////////
/////    Selector Shader to outline an object                                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec4 m_Color;
uniform float m_Linethickness;

varying vec3 position;
varying vec2 texCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 fragColor = m_Color;
    
    if(texCoord.x > m_Linethickness && texCoord.x < (1.0-m_Linethickness) && texCoord.y > m_Linethickness && texCoord.y < (1.0-m_Linethickness)){
        discard;
    }
    
    gl_FragColor = fragColor;  
    
    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}