////////////////////////////////////////////////////////////////////////////////////
/////    Sky Shader for daytime-dependent sky                                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_ProjectionMatrix;
uniform mat4 g_ViewMatrix;
uniform float g_Time;

uniform vec3 m_SunPosition;
uniform vec4 m_OverlayFog;
uniform vec4 m_Fog;

uniform float m_CloudAlpha;

uniform float m_Height;
uniform float m_BorderLevel;  //Range -1 - 200

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec3 position;
varying vec2 texCoord;
varying vec2 cloudCoord;
varying vec2 cloudCoord2;
varying float border;
varying vec3 sunsetColor;
varying vec4 overlayFog;
varying vec4 fog;
varying float flicker;
varying float cloudalpha;
varying float overclouds;

const float PI = 3.14159;
const vec3 sunsetOrange = vec3(1.0, 0.81, 0.39);  //vec3(1.0, 0.54, 0.0)
const vec3 sunsetRed = vec3(1.0, 0.29, 0.0);

void main(){
    vec4 pos = vec4(inPosition, 0.0);
    pos = g_ViewMatrix * pos;  //matrix * vector!
    pos.w = 1.0;
    gl_Position = g_ProjectionMatrix * pos;

    #ifdef FOG
        vec4 vertex = vec4(pos);
        float dist = 500.0;  //fixed value since the sky has a fixed distance
        fog = m_Fog;
        fog.w = exp2(-m_Fog.w * m_Fog.w * dist * dist * 1.442695);
        fog.w = clamp(fog.w, 0.0, 1.0);
        
        //Overlay Fog
        overlayFog = vec4(m_Fog.rgb, m_OverlayFog.a);

        //Sunset and Sunrise color
        vec3 newSunPosition = vec3(m_SunPosition);
        newSunPosition.y = -50.0;
        vec3 sunsetGrad = mix(sunsetRed, sunsetOrange, smoothstep(0.0, 50.0, m_SunPosition.y + (100.0 * step(0.0, -m_SunPosition.x))));
        vec3 sunsetColor = mix(sunsetGrad, fog.rgb, smoothstep(40.0, 60.0, m_SunPosition.y));
        sunsetColor = mix(fog.rgb, sunsetColor.rgb, smoothstep(-7.5, 0.0, m_SunPosition.y));  //-10.0 ?
        float distToSunXZ = distance(inPosition.xyz, newSunPosition.xyz) + (500.0 * (1.0 - step(0.0, inPosition.y))) + (250.0 * smoothstep(0.0, 70.0, m_BorderLevel));
        fog.rgb = mix(sunsetColor.rgb, fog.rgb, smoothstep(60.0, 280.0, distToSunXZ));
    #else
        overlayFog = m_OverlayFog;
    #endif
    
    position = inPosition;
    texCoord = inTexCoord;
    
    cloudCoord = inTexCoord;
    cloudCoord2 = inTexCoord;
    border = m_BorderLevel;
    
    overclouds = smoothstep(500.0, 600.0, m_Height);
    
    float factor = max(1.0 - smoothstep(0.0, 650.0, m_Height), 0.00001);
    cloudalpha = (1.0 - overclouds) * m_CloudAlpha;
    cloudCoord *= factor;
    cloudCoord += (1.0 - (factor * 0.5));
    cloudCoord2 *= factor;
    cloudCoord2 += (1.0 - (factor * 0.5));
    
    float speed = g_Time * 0.0018;
    float speed2 = g_Time * 0.003;
    cloudCoord.x -= mod(speed, 1.0);
    cloudCoord2.x -= mod(speed2, 1.0);
    cloudCoord2.y += 0.25;
    
    flicker = (0.99 + (sin((((inTexCoord.x + inTexCoord.y)) + g_Time) * 10.0) * 0.075));
}