////////////////////////////////////////////////////////////////////////////////////
/////    PostShadow Shader for determing post-shadow calculation               /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Common/ShaderLib/Skinning.glsllib"

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform mat4 g_ViewMatrix;

uniform mat4 m_LightViewProjectionMatrix0;
uniform mat4 m_LightViewProjectionMatrix1;
uniform mat4 m_LightViewProjectionMatrix2;
uniform mat4 m_LightViewProjectionMatrix3;
uniform vec3 m_LightPos;

attribute vec3 inPosition;
attribute vec4 inColor;

varying float intensity;

varying vec4 projCoord0;
varying vec4 projCoord1;
varying vec4 projCoord2;
varying vec4 projCoord3;

#ifdef PSSM
    varying float shadowPosition;
#endif
varying vec3 lightVec;

const mat4 biasMat = mat4(
0.5, 0.0, 0.0, 0.0,
0.0, 0.5, 0.0, 0.0,
0.0, 0.0, 0.5, 0.0,
0.5, 0.5, 0.5, 1.0);

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef PSSM
        shadowPosition = gl_Position.z;
    #endif

    vec4 worldPos = g_WorldMatrix * pos;

    projCoord0 = biasMat * m_LightViewProjectionMatrix0 * worldPos;
    projCoord1 = biasMat * m_LightViewProjectionMatrix1 * worldPos;
    projCoord2 = biasMat * m_LightViewProjectionMatrix2 * worldPos;
    projCoord3 = biasMat * m_LightViewProjectionMatrix3 * worldPos;

    vec4 vLightPos = g_ViewMatrix * vec4(m_LightPos, 1.0);
    vec4 vPos = g_ViewMatrix * worldPos;
    lightVec = vLightPos.xyz - vPos.xyz;

    intensity = step(0.6, inColor.w);
}