////////////////////////////////////////////////////////////////////////////////////
/////    PostShadow Shader for determing post-shadow calculation               /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Common/ShaderLib/Shadows.glsllib"

#ifdef PSSM
    varying float shadowPosition;
#endif

varying vec4 projCoord0;
varying vec4 projCoord1;
varying vec4 projCoord2;
varying vec4 projCoord3;

varying float intensity;

#ifdef FADE
    uniform vec2 m_FadeInfo;
#endif

void main(){
    float shadow = 1.0;

    #ifdef PSSM
        shadow = getDirectionalLightShadows(m_Splits, shadowPosition,
        m_ShadowMap0, m_ShadowMap1, m_ShadowMap2, m_ShadowMap3,
        projCoord0, projCoord1, projCoord2, projCoord3);
    #else
        //spotlight
        shadow = getSpotLightShadows(m_ShadowMap0, projCoord0);
    #endif

    #ifdef FADE
        shadow = max(0.0,mix(shadow,1.0,(shadowPosition - m_FadeInfo.x) * m_FadeInfo.y));
    #endif
    shadow = shadow * m_ShadowIntensity + (1.0 - m_ShadowIntensity);

    shadow *= intensity;

    gl_FragColor = vec4(shadow, shadow, shadow, 1.0);
}