////////////////////////////////////////////////////////////////////////////////////
/////    PreWaterShader to determine bodies of water                           /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;

uniform float m_Time;

attribute vec3 inPosition;

varying vec4 position;
varying vec3 worldpos;
varying vec2 watertex1;
varying vec2 watertex2;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    
    position = pos;
    worldpos = vec3(g_WorldMatrix * pos);
    
    vec2 tex1 = vec2(0.0, -m_Time);
    vec2 tex2 = vec2(0.0, m_Time);

    watertex1 = worldpos.xz * 0.01 + tex1;
    watertex2 = worldpos.xz * 0.01 + tex2;
    
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
}