////////////////////////////////////////////////////////////////////////////////////
/////    PreWaterShader to determine bodies of water                           /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_WaterTexture;
uniform sampler2D m_NormalTexture;
uniform sampler2D m_DUDVTexture;

uniform float m_TextureScale;
uniform float m_DistortionScale;
uniform float m_DistortionMix;
uniform float m_WaterDepth;

varying vec4 position;
varying vec3 worldpos;
varying vec2 watertex1;
varying vec2 watertex2;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const vec4 mone = vec4(-1.0, -1.0, -1.0, 1.0);
const vec4 two = vec4(2.0, 2.0, 2.0, 1.0);
const vec4 ofive = vec4(0.5, 0.5, 0.5, 1.0);

void main(){
    vec4 disdis = texture2D(m_DUDVTexture, watertex2 * m_TextureScale);
    vec4 dist = texture2D(m_DUDVTexture, watertex1 + vec2(disdis) * m_DistortionMix);
    dist = normalize(dist * 2.0 - 1.0) * m_DistortionScale;

    //Normalmap
    vec4 normalMap = texture2D(m_NormalTexture, watertex1 + vec2(disdis) * m_DistortionMix);
    normalMap = (normalMap - ofive) * two;
    vec4 vNorm = normalize(normalMap);
    
    //Get projective texcoords
    vec4 projCoord = position / position.w;
    projCoord = (projCoord + 1.0) * 0.5 + dist;
    //projCoord = clamp(projCoord, 0.001, 0.999);
    
    vec4 fragColor = texture2D(m_NormalTexture, watertex1 + vec2(disdis) * m_DistortionMix);
    fragColor.a = 1.0;
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}