////////////////////////////////////////////////////////////////////////////////////
/////    SelectorFilter Shader for transparent previews (Post Processing)      /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_Texture;
uniform sampler2D m_PrePassTexture;
uniform float m_Opacity;
varying vec2 texCoord;

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    vec4 prePassColor = texture2D(m_PrePassTexture, texCoord);
    fragColor = mix(fragColor, prePassColor, m_Opacity);
    gl_FragColor = fragColor;
}
