////////////////////////////////////////////////////////////////////////////////////
/////    DepthOfField Filter Shader                                            /////
/////    Based on JMonkey Depth-Of-Field Filter                                /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#else
    uniform vec2 g_FrustumNearFar;
#endif

uniform sampler2D m_Texture;
uniform sampler2D m_DepthTexture;

uniform float m_FocusDistance;
uniform float m_FocusRange;
uniform float m_XScale;
uniform float m_YScale;

varying vec2 texCoord;

const vec2 nearFar = vec2(0.1, 1000.0);

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    float depthvalue = texture2D(m_DepthTexture, texCoord).r;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        float depth = convertLogDepthBufferToZ(depthvalue, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #else
        float depth = depthvalue;
    #endif
    
    float a = g_FrustumNearFar.y / (g_FrustumNearFar.y - g_FrustumNearFar.x);
    float b = g_FrustumNearFar.y * g_FrustumNearFar.x / (g_FrustumNearFar.x - g_FrustumNearFar.y);
    float z = b / (depth - a);
    
    float unfocus = min(1.0, abs(z - m_FocusDistance * 100.0) / m_FocusRange);
    
    //Depth < 1.0 to avoid blur of sky
    if(unfocus > 0.2 && depthvalue < 1.0){
        vec4 sum = vec4(0.0);
        
        float x = texCoord.x;
        float y = texCoord.y;
        
        sum += texture2D(m_Texture, vec2(x - 2.0 * m_XScale, y - 2.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 0.0 * m_XScale, y - 2.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x + 2.0 * m_XScale, y - 2.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 1.0 * m_XScale, y - 1.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x + 1.0 * m_XScale, y - 1.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 2.0 * m_XScale, y - 0.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x + 2.0 * m_XScale, y - 0.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 1.0 * m_XScale, y + 1.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x + 1.0 * m_XScale, y + 1.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 2.0 * m_XScale, y + 2.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x - 0.0 * m_XScale, y + 2.0 * m_YScale));
        sum += texture2D(m_Texture, vec2(x + 2.0 * m_XScale, y + 2.0 * m_YScale));
        
        sum /= 12.0;

        fragColor = mix(fragColor, sum, unfocus);
    }
    
    gl_FragColor = fragColor;
}
