////////////////////////////////////////////////////////////////////////////////////
/////    Particle Shader                                                       /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;

#ifdef POINTSPRITE
    uniform mat4 g_WorldViewMatrix;
    uniform mat4 g_WorldMatrix;
    uniform vec3 g_CameraPosition;

    uniform float m_Quadratic;

    attribute float inSize;
#endif

uniform float m_TextureScale;

attribute vec3 inPosition;
attribute vec4 inColor;
attribute vec4 inTexCoord;

varying vec3 position;
varying vec4 texCoord;
varying vec4 color;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float SIZE_MULTIPLIER = 4.0;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    position = inPosition;
    texCoord = inTexCoord * m_TextureScale;
    color = inColor;

    #ifdef POINTSPRITE
        vec4 worldpos = g_WorldMatrix * pos;
        float dist = distance(g_CameraPosition.xyz, worldpos.xyz);
        float size = (inSize * SIZE_MULTIPLIER * m_Quadratic) / dist;
        gl_PointSize = max(1.0, size);
    #endif

}