////////////////////////////////////////////////////////////////////////////////////
/////    Particle Shader                                                       /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform float m_AlphaDiscardThreshold;
uniform vec4 m_Color;
uniform float m_Opacity;

varying vec3 position;
varying vec4 texCoord;
varying vec4 color;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef TEXTURE
        #ifdef POINTSPRITE
            vec2 uv = mix(texCoord.xy, texCoord.zw, gl_PointCoord.xy);
        #else
            vec2 uv = texCoord.xy;
        #endif
        
        vec4 fragColor = texture2D(m_Texture, uv) * color;
    #else
        vec4 fragColor = color;
    #endif

    #ifdef COLOR
        #ifdef MULTCOLOR
            fragColor *= m_Color;
        #else
            fragColor.rgb = mix(fragColor.rgb, m_Color.rgb, m_Color.a);
        #endif
    #endif

    if(fragColor.a < m_AlphaDiscardThreshold){
        discard;
    }
    
    //Opacity
    fragColor.a *= m_Opacity;
    
    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}