////////////////////////////////////////////////////////////////////////////////////
/////    Ore Shader for use with marching-cubes generated Ores                 /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Staticlighting.glsllib"
#import "Shaders/Lib/Pointlighting.glsllib"

#ifdef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif
#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraDirection;

attribute vec3 inPosition;
attribute vec3 inTexCoord;
attribute vec3 inNormal;
attribute vec4 inColor;

varying vec3 position;
varying vec3 texCoord;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 blending;
varying vec3 light;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        calculateFog(viewpos, fog);
    #endif
    
    texCoord = inTexCoord;
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    normal = inNormal;

    //Blending calculation for triplanar mapping
    blending = abs(normal);
    blending = (blending - 0.2);
    blending = normalize(max(blending, 0.00001)); //Force weights to sum to 1.0 (very important!)
    blending /= (blending.x + blending.y + blending.z);
    
    //Staticlight calculation
    vec4 color = vec4(inColor.r * 0.01, inColor.g * 0.01, inColor.b * 0.01, inColor.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    calculateStaticlight(normal, color, light, g_CameraDirection, shininess);

    //Per-Vertex-Lighting calculation (dynamic Pointlights)
    light = calculatePointlights(light, worldpos, normal, g_CameraDirection, shininess);
    
    //Optional: Per-Vertex-Lighting calculation (dynamic Spotlights)
    #ifdef VERTEXLIGHTING
        light = calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #endif
    
    //Fogcolor calculation
    fog.xyz *= (max(color.r, color.w) * m_Sunlight.w);
}