////////////////////////////////////////////////////////////////////////////////////
/////    Grass Occlusion Pre Shader to render occluding objects                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

#if defined(VEGETATION) || defined(OBJECT)
    varying vec4 texCoord;
#endif

#if defined(LOGARITHMIC_DEPTH_BUFFER)
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 fragColor = vec4(1.0);
    
    #if defined(OBJECT)
        //Maskedtextures
        if(texCoord.w >= 0.5){
            discard;
        }
    #else
        #if defined(VEGETATION)
            //Non-bark textures
            if(texCoord.w >= 0.5){
                discard;
            }
        #endif
    #endif
    
    gl_FragColor = fragColor;

    #if defined(LOGARITHMIC_DEPTH_BUFFER)
        //gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}