////////////////////////////////////////////////////////////////////////////////////
/////    AnimatedSprite Shader for image-based 2D-Animations                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform vec4 m_OverlayColor;
uniform float m_AlphaDiscardThreshold;

varying vec2 texCoord;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    
    #ifdef OVERLAYCOLOR
        fragColor *= m_OverlayColor;
    #endif

    if(fragColor.a < m_AlphaDiscardThreshold){
        discard;
    }
    
    gl_FragColor = fragColor;  

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}