////////////////////////////////////////////////////////////////////////////////////
/////    HellLava Shader for the low-level Lava in hell                        /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat4 g_WorldMatrix;
uniform float g_Time;

uniform vec4 m_Fog;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec2 texCoord1;
varying vec2 texCoord2;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    pos.y += 0.325 * sin(g_Time * mod(inPosition.x, 1.0) * mod(inPosition.z, 1.0) * 5.5);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        float dist = length(viewpos.xyz);
        fog = m_Fog;
        fog.w = exp2(-m_Fog.w * m_Fog.w * dist * dist * 1.442695);
        fog.w = clamp(fog.w, 0.0, 1.0);
    #endif
    
    vec3 worldPos = vec3(g_WorldMatrix * pos);
    texCoord1 = vec3(worldPos).xz;
    texCoord2 = vec3(worldPos).xz;
    float flow = g_Time * 0.15;
    texCoord1.xy += flow;
    texCoord2.x -= flow;
    texCoord2.y += flow;
}