////////////////////////////////////////////////////////////////////////////////////
/////    HellLava Shader for the low-level Lava in hell                        /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform sampler2D m_Texture;
uniform vec4 m_Color;

varying vec2 texCoord1;
varying vec2 texCoord2;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef TEXTURE
        vec4 fragColor = mix(texture2D(m_Texture, texCoord1*0.05) * 1.25, texture2D(m_Texture, texCoord2*0.25), 0.5);
        #ifdef COLOR
            fragColor = mix(fragColor, m_Color, 0.5);
        #endif
    #else
        #ifdef COLOR
            vec4 fragColor = m_Color;
        #else
            vec4 fragColor = vec4(1.0);
        #endif
    #endif
    
    #ifdef FOG
        fragColor.xyz = mix(fog.xyz, fragColor.xyz, fog.w);
    #endif

    gl_FragColor = fragColor;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}