////////////////////////////////////////////////////////////////////////////////////
/////    Weather Shader for weather effects like rain or snow                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler3D m_Texture;
//uniform sampler2DArray m_Textures_Array;

uniform sampler2D m_OccludeDepthTexture;

#import "Shaders/Lib/Pointlighting.glsllib"
#ifndef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

uniform vec3 g_CameraPosition;
uniform vec3 g_CameraDirection;

uniform mat4 m_OccludeMatrix;
uniform mat3 m_OccludeRotationMatrix;
uniform vec3 m_OccludeCameraPosition;
uniform vec2 m_OccludeOffset;

varying vec3 position;
varying vec4 rainCoord;
varying vec4 snowCoord;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 invcamdir;
varying vec3 light;
varying vec4 fog;
varying float fade;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

vec3 getOcclusionPosition(in float depth, in vec2 uv){
    vec4 pos = vec4(uv, depth, 1.0) * 2.0 - 1.0;
    pos = m_OccludeMatrix * pos;
    return pos.xyz / pos.w;
}

vec2 getOccludeTexCoord(in vec3 worldpos){
    vec3 newWp = m_OccludeRotationMatrix * (worldpos - g_CameraPosition);
    vec3 newCp = m_OccludeRotationMatrix * (m_OccludeCameraPosition);
    vec2 occTexCoord = vec2(newWp.xz - newCp.xz) * 6.375;
    //occTexCoord -= m_OccludeOffset;
    //float hx = occTexCoord.x;
    //occTexCoord.x = -occTexCoord.y;
    //occTexCoord.y = hx;


    occTexCoord.x = -occTexCoord.x;
    occTexCoord.y = occTexCoord.y;
    occTexCoord.x += 128.0;
    occTexCoord.y += 128.0;
    occTexCoord /= 256.0;
    return occTexCoord;
}

void main(){
    float fadevalue = fade;

    #ifdef OCCLUSION
        vec2 occTexCoord = getOccludeTexCoord(worldpos);
        if(occTexCoord.x > 0.0 && occTexCoord.x < 1.0 && occTexCoord.y > 0.0 && occTexCoord.y < 1.0){
            float depth = texture2D(m_OccludeDepthTexture, occTexCoord).r;
            
            #ifdef LOGARITHMIC_DEPTH_BUFFER
                //depth = convertLogDepthBufferToZ(depth, g_FrustumNearFar.x, g_FrustumNearFar.y);
            #endif
            
            float occludePosition = getOcclusionPosition(depth, occTexCoord).y + 1.0;
            if(worldpos.y < occludePosition){
                fadevalue = min(fade, 1.0 - smoothstep(0.0, 1.0, abs(occludePosition - worldpos.y)));//discard;
            }
        }
        else if(worldpos.y < 255.0){
            discard;
        }
    #endif

    #ifdef TEXTURE
        //Rain
        vec4 fragColor = vec4(0.0);
        if(rainCoord.z > -0.5){
            fragColor = texture3D(m_Texture, rainCoord.xyz);
            fragColor.a *= (rainCoord.w * 0.5);
        }
        
        if(snowCoord.z > -0.5){
            vec4 snowColor = texture3D(m_Texture, snowCoord.xyz);
            snowColor.a *= snowCoord.w;
            fragColor = max(fragColor, snowColor);
        }
        
        ////TEXTURE ARRAY
        //vec4 fragColor = texture2DArray(m_Textures_Array, vec3(texCoord.xy, m_WeatherInfo.x));
        //fragColor.a *= (m_WeatherInfo.z * 0.2);
        //if(m_WeatherInfo.y >= -0.5){
        //    vec4 blendColor = texture2DArray(m_Textures_Array, vec3(texCoord.xy, m_WeatherInfo.y));
        //    blendColor.a *= m_WeatherInfo.w;
        //    fragColor = mix(fragColor, blendColor, blendColor.a);
        //}
    #else
        vec4 fragColor = vec4(1.0, 0.0, 0.0, 0.5);
    #endif

    fragColor.a *= (smoothstep(1.0, 4.0, distance(worldpos, g_CameraPosition)) * fadevalue);
    
    //Discard
    if(fragColor.a < 0.05){
        discard;
    }

    //Per-Vertex-Lighting calculation (dynamic Pointlights)
    vec3 lighting = calculatePointlights(light, worldpos, invcamdir, g_CameraDirection, shininess);
    
    //If normal-quality light is enabled: Per-Pixel-Lighting calculation (dynamic Spotlights)
    #ifndef VERTEXLIGHTING
        fragColor.rgb *= calculateSpotlights(lighting, worldpos, invcamdir, g_CameraDirection, shininess);
    #else
        fragColor.rgb *= lighting;
    #endif
    
    gl_FragColor = fragColor;
    
    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}