////////////////////////////////////////////////////////////////////////////////////
/////    NoRefraction Shader                                                   /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_WorldViewProjectionMatrix;

attribute vec3 inPosition;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

#ifdef MASKTEXTURES
    attribute vec2 inTexCoord;
    varying vec2 texCoord;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef MASKTEXTURES
        texCoord = inTexCoord;
    #endif
}