////////////////////////////////////////////////////////////////////////////////////
/////    Sky Shader for daytime-dependent sky                                  /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

uniform mat4 g_ProjectionMatrix;
uniform mat4 g_ViewMatrix;
uniform mat4 g_WorldMatrix;

uniform vec4 m_Fog;

attribute vec3 inPosition;
attribute vec2 inTexCoord;

varying vec3 position;
varying vec2 texCoord;
varying vec4 fog;

void main(){
    vec4 pos = vec4(inPosition, 0.0);
    pos = g_ViewMatrix * pos;  //matrix * vector!
    pos.w = 1.0;
    gl_Position = g_ProjectionMatrix * pos;
    
    #ifdef FOG
        vec4 vertex = vec4(pos);
        float dist = 500.0;  //fixed value since the sky has a fixed distance
        fog = m_Fog;
        fog.w = exp2(-m_Fog.w * m_Fog.w * dist * dist * 1.442695);
        fog.w = clamp(fog.w, 0.0, 1.0);
        
        //Sunset and Sunrise color
        /*vec3 newSunPosition = vec3(m_SunPosition);
        newSunPosition.y = -50.0;
        vec3 sunsetGrad = mix(sunsetRed, sunsetOrange, smoothstep(0.0, 50.0, m_SunPosition.y + (100.0 * step(0.0, -m_SunPosition.x))));
        vec3 sunsetColor = mix(sunsetGrad, fog.rgb, smoothstep(40.0, 60.0, m_SunPosition.y));
        sunsetColor = mix(fog.rgb, sunsetColor.rgb, smoothstep(-7.5, 0.0, m_SunPosition.y));  //-10.0 ?
        float distToSunXZ = distance(inPosition.xyz, newSunPosition.xyz);
        fog.rgb = mix(sunsetColor.rgb, fog.rgb, smoothstep(60.0, 180.0, distToSunXZ));*/
    #endif
    
    position = inPosition;
    texCoord = inTexCoord;
}