////////////////////////////////////////////////////////////////////////////////////
/////    NoRefraction Shader for all objects with no refraction                /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef INSTANCING
    #import "Shaders/Lib/Instancing.glsllib"

    #ifdef WIND
        uniform float g_Time;
        #import "Shaders/Lib/Wind.glsllib"
    #endif
#else
    uniform mat4 g_WorldViewProjectionMatrix;
#endif

attribute vec3 inPosition;

#ifdef MASKTEXTURES
    attribute vec3 inTexCoord;
    varying vec3 texCoord;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    
    #ifdef INSTANCING
        //Windeffect (Vegetations)
        #ifdef WIND
            pos.xz += getInstancedVegetationWind(inPosition);
        #endif
        
        gl_Position = transformWorldViewProjection(pos);
    #else
        gl_Position = g_WorldViewProjectionMatrix * pos;
    #endif

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
    
    #ifdef MASKTEXTURES
        texCoord = inTexCoord;
    #endif
}