////////////////////////////////////////////////////////////////////////////////////
/////    NoColorShader for all objects that shall not appear on PrePassTexture /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

#ifdef LOGARITHMIC_DEPTH_BUFFER
    #import "Shaders/Lib/LogarithmicDepth.glsllib"
#endif

#ifdef MASKTEXTURES
    uniform sampler2D m_MaskTexture;
    varying vec2 texCoord;
#endif

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

void main(){
    #ifdef MASKTEXTURES
        float alpha = texture2D(m_MaskTexture, texCoord).r;
        alpha = step(0.5, alpha);
        gl_FragColor = vec4(0.0, 0.0, 0.0, alpha);
    #else
        gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
    #endif

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        gl_FragDepth = computeLogDepthBuffer(positionProjectionSpace.z, g_FrustumNearFar.x, g_FrustumNearFar.y);
    #endif
}