////////////////////////////////////////////////////////////////////////////////////
/////    NightVisionFilter Shader (Post Processing)                            /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Fragment-Shader                                                       /////
////////////////////////////////////////////////////////////////////////////////////

uniform sampler2D m_Texture;
uniform float g_Time;

varying vec2 texCoord;

void main(){
    vec4 fragColor = texture2D(m_Texture, texCoord);
    fragColor = fragColor * vec4(0.0, 1.0, 0.0, 1.0);
    float noise = 0.5 + 0.5 * fract(sin(dot(trunc(texCoord * 750.0) + fract(g_Time), vec2(12.9898, 78.233))) * 43758.5453);
    fragColor = fragColor + (noise * 0.175);
    gl_FragColor = fragColor; 
}
