////////////////////////////////////////////////////////////////////////////////////
/////    LOD Shader for combined LOD-Terrain, -Vegetation and -Objects         /////
/////    Author: Danny Imlau (JIW-Games)                                       /////
/////    Vertex-Shader                                                         /////
////////////////////////////////////////////////////////////////////////////////////

#import "Shaders/Lib/Staticlighting.glsllib"
#import "Shaders/Lib/Pointlighting.glsllib"
#ifdef VERTEXLIGHTING
    #import "Shaders/Lib/Spotlighting.glsllib"
#endif
#ifdef FOG
    #import "Shaders/Lib/Fog.glsllib"
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldViewMatrix;
uniform mat3 g_WorldMatrixInverseTranspose;
uniform mat4 g_WorldMatrix;
uniform vec3 g_CameraPosition;
uniform vec3 g_CameraDirection;
uniform float g_Time;

uniform float m_Viewdistance;

attribute vec3 inPosition;
attribute vec3 inNormal;
attribute vec4 inColor;
attribute vec4 inTexCoord;
attribute vec4 inTexCoord2;
attribute vec4 inTexCoord3;
attribute vec4 inTexCoord4;
attribute vec4 inTexCoord5;
attribute float inTexCoord8;

varying vec3 position;
varying vec3 worldpos;
varying vec3 normal;
varying vec3 light;
varying vec3 blending;
varying vec4 texCoord;
varying vec4 texCoord2;
varying vec4 texCoord3;
varying vec4 texCoord4;
varying vec4 texCoord5;
varying vec2 texCoord8;
varying vec4 fog;

#ifdef LOGARITHMIC_DEPTH_BUFFER
    varying vec4 positionProjectionSpace;
#endif

const float shininess = 1.0;

void main(){
    vec4 pos = vec4(inPosition, 1.0);
    
    #ifdef FOG
        vec4 viewpos = g_WorldViewMatrix * pos;
        calculateFog(viewpos, fog);
    #endif
    
    texCoord2 = inTexCoord2 * 0.01;
    texCoord3 = inTexCoord3 * 0.01;
    texCoord4 = inTexCoord4 * 0.01;
    texCoord5 = inTexCoord5 * 0.01;
    texCoord8 = vec2(inTexCoord8);
    
    position = inPosition;
    worldpos = vec3(g_WorldMatrix * pos);
    normal = inNormal * 0.01;
    texCoord = inTexCoord;

    //0=Terrain, 1=Blocks, 2=Vegetation, 3=Objects
    float sundot = 0.0;
    vec4 color = vec4(inColor.r * 0.01, inColor.g * 0.01, inColor.b * 0.01, inColor.a * 0.01);  //Color (light) ByteBuffer in Float umrechnen
    if(inTexCoord.w <= 0.5){
        sundot = dot(m_Sunlight.xyz, normal);
        
        float distx = step(m_Viewdistance+1.0, abs(worldpos.x - (floor(g_CameraPosition.x / 16.0) * 16.0)) + (16.0 * step(worldpos.x, g_CameraPosition.x)));
        float distz = step(m_Viewdistance+1.0, abs(worldpos.z - (floor(g_CameraPosition.z / 16.0) * 16.0)) + (16.0 * step(worldpos.z, g_CameraPosition.z)));
        pos.y -= (2.0 - (max(distx, distz) * 2.0));
        
        //Staticlight calculation
        calculateStaticlight(normal, color, light, g_CameraDirection, shininess);
    }
    else{
        pos.xz += 0.05 * (1.0 - inTexCoord.y) * sin(g_Time * 2.25 + mod(pos.xz, 5.0));
        
        vec3 bi = normalize(vec3(inTexCoord.x - 0.5, inTexCoord.y, inTexCoord.x - 0.5));
        sundot = mix(dot(m_Sunlight.xyz, bi), dot(m_Sunlight.xyz, normal), 0.5);
        //sundot = dot(m_Sunlight.xyz, bi) * (1.0 - (0.5 * step(-0.5, dot(m_Sunlight.xyz, normal))));
        
        //Staticlight calculation
        calculateStaticlightBySundot(sundot, color, light);
    }

    //Blending calculation for triplanar mapping
    #ifdef TRIPLANARBLENDING
        blending = abs(normal);
        blending = (blending - 0.2);
        blending = normalize(max(blending, 0.00001)); //Force weights to sum to 1.0 (very important!)
        blending /= (blending.x + blending.y + blending.z);
    #endif

    //Per-Vertex-Lighting calculation (dynamic Pointlights)
    light = calculatePointlights(light, worldpos, normal, g_CameraDirection, shininess);
    
    //Optional: Per-Vertex-Lighting calculation (dynamic Spotlights)
    #ifdef VERTEXLIGHTING
        light = calculateSpotlights(light, worldpos, normal, g_CameraDirection, shininess);
    #endif
    
    //Fogcolor calculation
    //fog.xyz *= (max(color.r, color.w) * m_Sunlight.w);
    
    gl_Position = g_WorldViewProjectionMatrix * pos;

    #ifdef LOGARITHMIC_DEPTH_BUFFER
        positionProjectionSpace = gl_Position;
    #endif
}